/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.commands;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.model.PlayerIPData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class PlayerInfoCmd
implements CommandExecutor,
TabCompleter {
    private final UnifiedSecureMgr plugin;

    public PlayerInfoCmd(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        PlayerIPData ipData;
        if (!sender.hasPermission("unified.playerinfo")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /getinfo <player>");
            return true;
        }
        OfflinePlayer target = this.plugin.getServer().getOfflinePlayer(args[0]);
        UUID uuid = target.getUniqueId();
        sender.sendMessage("\u00a76\u00a7l=== Player Information ===");
        sender.sendMessage("\u00a7eName: \u00a7f" + target.getName());
        sender.sendMessage("\u00a7eUUID: \u00a7f" + String.valueOf(uuid));
        sender.sendMessage("\u00a7eOnline: \u00a7f" + (target.isOnline() ? "\u00a7aYes" : "\u00a7cNo"));
        if (this.plugin.getIPTracker() != null && (ipData = this.plugin.getIPTracker().getPlayerData(uuid)) != null) {
            sender.sendMessage("\u00a7eCurrent IP: \u00a7f" + ipData.getCurrentIP());
            sender.sendMessage("\u00a7eTotal IPs: \u00a7f" + ipData.getIpHistory().size());
            sender.sendMessage("\u00a7eFirst Join: \u00a7f" + String.valueOf(new Date(ipData.getFirstJoin())));
            sender.sendMessage("\u00a7eLast Seen: \u00a7f" + String.valueOf(new Date(ipData.getLastJoin())));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return null;
        }
        return new ArrayList<String>();
    }
}

