/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.commands;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.model.PlaytimeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class PlaytimeCmd
implements CommandExecutor,
TabCompleter {
    private final UnifiedSecureMgr plugin;

    public PlaytimeCmd(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("unified.playtime")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /ptime <player> [session|daily|weekly|monthly|yearly|total]");
            return true;
        }
        OfflinePlayer target = this.plugin.getServer().getOfflinePlayer(args[0]);
        UUID uuid = target.getUniqueId();
        PlaytimeData data = this.plugin.getStorageProvider().loadPlaytimeData(uuid);
        if (data == null) {
            sender.sendMessage("\u00a7cNo playtime data found for " + target.getName());
            return true;
        }
        long totalMs = data.getTotalPlaytime();
        long hours = TimeUnit.MILLISECONDS.toHours(totalMs);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(totalMs) % 60L;
        sender.sendMessage("\u00a76\u00a7l=== Playtime for " + target.getName() + " ===");
        sender.sendMessage("\u00a7eTotal: \u00a7f" + hours + "h " + minutes + "m");
        sender.sendMessage("\u00a7eOnline: \u00a7f" + (data.isOnline() ? "\u00a7aYes" : "\u00a7cNo"));
        if (data.isOnline() && data.getSessionStart() > 0L) {
            long sessionMs = System.currentTimeMillis() - data.getSessionStart();
            long sessionHours = TimeUnit.MILLISECONDS.toHours(sessionMs);
            long sessionMinutes = TimeUnit.MILLISECONDS.toMinutes(sessionMs) % 60L;
            sender.sendMessage("\u00a7eCurrent Session: \u00a7f" + sessionHours + "h " + sessionMinutes + "m");
        }
        if (args.length > 1) {
            String period = args[1].toLowerCase();
            sender.sendMessage("\u00a77Detailed breakdown for specific periods is not yet available.");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            return null;
        }
        if (args.length == 2) {
            List<String> periods = Arrays.asList("session", "daily", "weekly", "monthly", "yearly", "total");
            String input = args[1].toLowerCase();
            for (String period : periods) {
                if (!period.startsWith(input)) continue;
                completions.add(period);
            }
            return completions;
        }
        return completions;
    }
}

