/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.commands;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.snapshot.PlayerSnapshot;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class SnapshotCmd
implements CommandExecutor,
TabCompleter {
    private final UnifiedSecureMgr plugin;

    public SnapshotCmd(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("unified.snapshot")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /snapshot <player>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage("\u00a7cPlayer not found!");
            return true;
        }
        if (this.plugin.getSnapshotSystem() == null) {
            sender.sendMessage("\u00a7cSnapshot system is not enabled!");
            return true;
        }
        PlayerSnapshot snapshot = this.plugin.getSnapshotSystem().createSnapshot(target);
        sender.sendMessage("\u00a7a\u00a7lSnapshot created for " + target.getName());
        sender.sendMessage("\u00a77UUID: \u00a7f" + String.valueOf(snapshot.getUuid()));
        sender.sendMessage("\u00a77Current IP: \u00a7f" + snapshot.getCurrentIp());
        sender.sendMessage("\u00a77Location: \u00a7f" + snapshot.getLocation());
        sender.sendMessage("\u00a77GameMode: \u00a7f" + snapshot.getGameMode());
        sender.sendMessage("\u00a77Health: \u00a7f" + snapshot.getHealth());
        sender.sendMessage("\u00a77Trust Score: \u00a7f" + snapshot.getTrustScore());
        sender.sendMessage("\u00a77Playtime: \u00a7f" + snapshot.getPlaytime() / 3600000L + " hours");
        if (snapshot.getPunishmentHistory() != null) {
            sender.sendMessage("\u00a77Punishments: \u00a7f" + snapshot.getPunishmentHistory().size());
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return null;
        }
        return new ArrayList<String>();
    }
}

