/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.commands;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.performance.PerformanceMonitor;
import com.unifiedsecure.performance.PerformanceReport;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class TPSCmd
implements CommandExecutor {
    private final UnifiedSecureMgr plugin;

    public TPSCmd(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("unified.tps")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (this.plugin.getPerformanceMonitor() == null) {
            sender.sendMessage("\u00a7cPerformance monitor is not enabled!");
            return true;
        }
        PerformanceMonitor monitor = this.plugin.getPerformanceMonitor();
        PerformanceReport report = monitor.generateReport();
        sender.sendMessage("\u00a76\u00a7l=== Server Performance ===");
        sender.sendMessage("\u00a7eTPS: " + monitor.getTPSColor(report.getCurrentTPS()) + String.format("%.2f", report.getCurrentTPS()) + " \u00a77(1m: " + String.format("%.2f", report.getAverage1m()) + ", 5m: " + String.format("%.2f", report.getAverage5m()) + ", 15m: " + String.format("%.2f", report.getAverage15m()) + ")");
        sender.sendMessage("\u00a7eMemory: " + monitor.getMemoryColor(report.getHeapPercent()) + report.getHeapUsed() + "MB \u00a77/ \u00a7f" + report.getHeapMax() + "MB \u00a77(" + report.getHeapPercent() + "%)");
        sender.sendMessage("\u00a7eThreads: \u00a7f" + report.getThreadCount() + " \u00a77(Peak: " + report.getPeakThreadCount() + ")");
        sender.sendMessage("\u00a7ePlayers: \u00a7f" + report.getOnlinePlayers() + " \u00a77/ \u00a7f" + report.getMaxPlayers());
        sender.sendMessage("\u00a7eWorlds: \u00a7f" + report.getWorldCount());
        long uptimeSeconds = report.getUptime() / 1000L;
        long days = uptimeSeconds / 86400L;
        long hours = uptimeSeconds % 86400L / 3600L;
        long minutes = uptimeSeconds % 3600L / 60L;
        sender.sendMessage("\u00a7eUptime: \u00a7f" + days + "d " + hours + "h " + minutes + "m");
        return true;
    }
}

