/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.commands;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.commands.HelpCmd;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class UnifiedCmd
implements CommandExecutor,
TabCompleter {
    private final UnifiedSecureMgr plugin;
    private final Map<UUID, Long> forgetConfirmation;
    private HelpCmd helpCmd;

    public UnifiedCmd(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.forgetConfirmation = new HashMap<UUID, Long>();
    }

    public void setHelpCmd(HelpCmd helpCmd) {
        this.helpCmd = helpCmd;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCmd;
        if (!sender.hasPermission("unified.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7cUsage: /unified <status|reload|forget|help>");
            return true;
        }
        switch (subCmd = args[0].toLowerCase()) {
            case "status": {
                return this.handleStatus(sender);
            }
            case "reload": {
                return this.handleReload(sender);
            }
            case "forget": {
                return this.handleForget(sender, args);
            }
            case "help": {
                if (this.helpCmd != null) {
                    String[] helpArgs = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
                    return this.helpCmd.onCommand(sender, command, label, helpArgs);
                }
                sender.sendMessage("\u00a7cHelp system not available.");
                return true;
            }
        }
        sender.sendMessage("\u00a7cUnknown subcommand. Use: status, reload, forget, help");
        return true;
    }

    private boolean handleStatus(CommandSender sender) {
        sender.sendMessage("\u00a76\u00a7l=== UnifiedSecureMgr Status ===");
        sender.sendMessage("\u00a77Version: \u00a7f" + this.plugin.getDescription().getVersion());
        sender.sendMessage("\u00a77Uptime: \u00a7f" + this.formatUptime(this.plugin.getUptime()));
        sender.sendMessage("\u00a77Storage: \u00a7f" + this.plugin.getConfigManager().getStorageType());
        try {
            Server server = Bukkit.getServer();
            Object minecraftServer = server.getClass().getMethod("getServer", new Class[0]).invoke((Object)server, new Object[0]);
            double[] recentTps = (double[])minecraftServer.getClass().getField("recentTps").get(minecraftServer);
            sender.sendMessage("\u00a77TPS: \u00a7f" + String.format("%.2f", recentTps[0]));
        }
        catch (Exception e) {
            sender.sendMessage("\u00a77TPS: \u00a7fUnavailable");
        }
        long freeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
        long totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
        long usedMemory = totalMemory - freeMemory;
        sender.sendMessage("\u00a77Memory: \u00a7f" + usedMemory + "MB / " + totalMemory + "MB");
        if (this.plugin.getIPTracker() != null) {
            sender.sendMessage("\u00a77IP Tracking: \u00a7aEnabled");
        }
        if (this.plugin.getAltDetector() != null) {
            sender.sendMessage("\u00a77Alt Detection: \u00a7aEnabled");
        }
        if (this.plugin.getPunishmentManager() != null) {
            int activeBans = this.plugin.getPunishmentManager().getAllActiveBans().size();
            sender.sendMessage("\u00a77Active Bans: \u00a7f" + activeBans);
        }
        if (this.plugin.getStaffModeManager() != null) {
            int staffOnline = this.plugin.getStaffModeManager().getStaffModeUsers().size();
            sender.sendMessage("\u00a77Staff Mode Users: \u00a7f" + staffOnline);
        }
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        sender.sendMessage("\u00a7eReloading configuration...");
        try {
            this.plugin.reload();
            sender.sendMessage("\u00a7aConfiguration reloaded successfully.");
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to reload configuration: " + e.getMessage());
            this.plugin.getLogger().warning("Failed to reload: " + e.getMessage());
        }
        return true;
    }

    private boolean handleForget(CommandSender sender, String[] args) {
        UUID senderUuid;
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /unified forget <player>");
            return true;
        }
        String targetName = args[1];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            sender.sendMessage("\u00a7cPlayer not found: \u00a7f" + targetName);
            return true;
        }
        UUID uUID = senderUuid = sender instanceof Player ? ((Player)sender).getUniqueId() : null;
        if (senderUuid != null && this.forgetConfirmation.containsKey(senderUuid)) {
            long lastConfirm = this.forgetConfirmation.get(senderUuid);
            if (System.currentTimeMillis() - lastConfirm < 10000L) {
                this.forgetConfirmation.remove(senderUuid);
                sender.sendMessage("\u00a7eDeleting all data for \u00a7f" + target.getName() + "\u00a7e...");
                this.plugin.getAsyncUtil().runAsync(() -> {
                    try {
                        if (this.plugin.getIPTracker() != null) {
                            this.plugin.getIPTracker().deletePlayerData(target.getUniqueId());
                        }
                        if (this.plugin.getPlaytimeTracker() != null) {
                            this.plugin.getPlaytimeTracker().deletePlayerData(target.getUniqueId());
                        }
                        if (this.plugin.getPunishmentManager() != null) {
                            this.plugin.getPunishmentManager().clearCache(target.getUniqueId());
                        }
                        this.plugin.getAsyncUtil().runSync(() -> sender.sendMessage("\u00a7aSuccessfully deleted all data for player: \u00a7f" + target.getName()));
                    }
                    catch (Exception e) {
                        this.plugin.getAsyncUtil().runSync(() -> sender.sendMessage("\u00a7cFailed to delete player data: \u00a7f" + e.getMessage()));
                    }
                });
                return true;
            }
        }
        if (senderUuid != null) {
            this.forgetConfirmation.put(senderUuid, System.currentTimeMillis());
        }
        sender.sendMessage("\u00a7c\u00a7lWARNING: \u00a7cThis will permanently delete all data for \u00a7f" + target.getName());
        sender.sendMessage("\u00a7cRun the command again within 10 seconds to confirm.");
        return true;
    }

    private String formatUptime(long millis) {
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis) % 24L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) % 60L;
        if (days > 0L) {
            return days + "d " + hours + "h " + minutes + "m";
        }
        if (hours > 0L) {
            return hours + "h " + minutes + "m";
        }
        return minutes + "m";
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("status", "reload", "forget", "help");
            String input = args[0].toLowerCase();
            for (String subCmd : subCommands) {
                if (!subCmd.startsWith(input)) continue;
                completions.add(subCmd);
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("forget")) {
            return null;
        }
        return completions;
    }
}

