/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.config;

import com.unifiedsecure.UnifiedSecureMgr;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final UnifiedSecureMgr plugin;
    private FileConfiguration config;
    private FileConfiguration langConfig;

    public ConfigManager(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.loadLanguageFile();
    }

    public void reload() {
        this.loadConfig();
    }

    private void loadLanguageFile() {
        File langFile = new File(this.plugin.getDataFolder(), "lang/english.yml");
        if (!langFile.exists()) {
            this.plugin.saveResource("lang/english.yml", false);
        }
        this.langConfig = YamlConfiguration.loadConfiguration((File)langFile);
        InputStream defConfigStream = this.plugin.getResource("lang/english.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.langConfig.setDefaults((Configuration)defConfig);
        }
    }

    public String getMessage(String path) {
        String message = this.langConfig.getString("messages." + path, "Message not found: " + path);
        String prefix = this.langConfig.getString("messages.prefix", "");
        return message.replace("%prefix%", prefix).replace("&", "\u00a7");
    }

    public String getWebhookMessage(String path) {
        return this.langConfig.getString("webhook." + path, "");
    }

    public boolean isFeatureEnabled(String feature) {
        return this.config.getBoolean("features." + feature, false);
    }

    public String getStorageType() {
        return this.config.getString("storage.type", "LOCAL");
    }

    public boolean shouldFailOnDbError() {
        return this.config.getBoolean("storage.failOnDbError", false);
    }

    public int getSaveIntervalSeconds() {
        return this.config.getInt("storage.local.saveIntervalSecs", 60);
    }

    public String getMySQLHost() {
        return this.config.getString("storage.mysql.host", "localhost");
    }

    public int getMySQLPort() {
        return this.config.getInt("storage.mysql.port", 3306);
    }

    public String getMySQLDatabase() {
        return this.config.getString("storage.mysql.database", "unified");
    }

    public String getMySQLUser() {
        return this.config.getString("storage.mysql.user", "username");
    }

    public String getMySQLPassword() {
        return this.config.getString("storage.mysql.password", "password");
    }

    public int getMySQLPoolSize() {
        return this.config.getInt("storage.mysql.poolSize", 5);
    }

    public boolean getMySQLUseSSL() {
        return this.config.getBoolean("storage.mysql.useSSL", false);
    }

    public String getSQLiteFileName() {
        return this.config.getString("storage.sqlite.fileName", "unified.db");
    }

    public int getThreadPoolSize() {
        return this.config.getInt("performance.threadPoolSize", 4);
    }

    public int getAsyncQueueCapacity() {
        return this.config.getInt("performance.asyncQueueCapacity", 1000);
    }

    public boolean isAutoSaveEnabled() {
        return this.config.getBoolean("performance.autoSaveOnShutdown", true);
    }

    public int getIPHistorySize() {
        return this.config.getInt("ip.ipHistorySize", 10);
    }

    public boolean isIPBanEnabled() {
        return this.config.getBoolean("ip.ban.enabled", true);
    }

    public String getIPBanKickMessage() {
        return this.config.getString("ip.ban.kickMessage", "You are banned by IP: %reason%").replace("&", "\u00a7");
    }

    public boolean shouldAutoCheckIPOnJoin() {
        return this.config.getBoolean("ip.ban.autoCheckOnJoin", true);
    }

    public boolean shouldBroadcastBansToStaff() {
        return this.config.getBoolean("ip.ban.broadcastToStaff", true);
    }

    public boolean isSilentKick() {
        return this.config.getBoolean("ip.ban.silentKick", false);
    }

    public boolean isAltDetectionEnabled() {
        return this.config.getBoolean("altDetection.enabled", true);
    }

    public int getSharedIPThreshold() {
        return this.config.getInt("altDetection.sharedIpThreshold", 2);
    }

    public int getAltTimeWindowDays() {
        return this.config.getInt("altDetection.timeWindowDays", 30);
    }

    public boolean shouldAutoTempban() {
        return this.config.getBoolean("altDetection.autoTempban", false);
    }

    public int getTempbanDurationSeconds() {
        return this.config.getInt("altDetection.tempbanDurationSecs", 86400);
    }

    public boolean shouldIgnoreWhitelist() {
        return this.config.getBoolean("altDetection.ignoreWhitelist", true);
    }

    public boolean isGeoIPEnabled() {
        return this.config.getBoolean("geoip.enabled", true);
    }

    public String getGeoIPProviderUrl() {
        return this.config.getString("geoip.providerUrl", "http://ip-api.com/json/{ip}");
    }

    public int getGeoIPCacheTTLMinutes() {
        return this.config.getInt("geoip.cacheTTLMinutes", 1440);
    }

    public long getGeoIPCooldownMs() {
        return this.config.getLong("geoip.cooldownMs", 500L);
    }

    public boolean shouldLookupGeoIPOnJoin() {
        return this.config.getBoolean("geoip.lookupOnJoin", true);
    }

    public boolean shouldLogToFiles() {
        return this.config.getBoolean("logging.logsToFiles", true);
    }

    public boolean shouldLogToDatabase() {
        return this.config.getBoolean("logging.logsToDatabase", false);
    }

    public int getFileRetentionDays() {
        return this.config.getInt("logging.fileRetentionDays", 7);
    }

    public boolean isLogCategoryEnabled(String category) {
        return this.config.getBoolean("logging.categories." + category, false);
    }

    public boolean isMetricsEnabled() {
        return this.config.getBoolean("logging.metrics.enabled", true);
    }

    public int getMetricsSamplingInterval() {
        return this.config.getInt("logging.metrics.samplingIntervalSecs", 300);
    }

    public boolean isCommandBlacklistEnabled() {
        return this.config.getBoolean("logging.blacklist.enabled", true);
    }

    public List<String> getBlacklistedCommands() {
        return this.config.getStringList("logging.blacklist.commands");
    }

    public boolean isPlayerWhitelistEnabled() {
        return this.config.getBoolean("logging.whitelist.enabled", true);
    }

    public List<String> getWhitelistedPlayers() {
        return this.config.getStringList("logging.whitelist.players");
    }

    public boolean isPlaytimeEnabled() {
        return this.config.getBoolean("playtime.enabled", true);
    }

    public boolean shouldTrackAFK() {
        return this.config.getBoolean("playtime.trackAFK", false);
    }

    public int getAFKThresholdSeconds() {
        return this.config.getInt("playtime.afkThresholdSeconds", 300);
    }

    public int getPlaytimeSaveInterval() {
        return this.config.getInt("playtime.saveIntervalSecs", 120);
    }

    public boolean isModerationEnabled() {
        return this.config.getBoolean("moderation.enabled", true);
    }

    public boolean shouldSyncWithBukkit() {
        return this.config.getBoolean("moderation.syncWithBukkit", true);
    }

    public String getDefaultBanReason() {
        return this.config.getString("moderation.defaultBanReason", "Violated server rules");
    }

    public String getDefaultMuteReason() {
        return this.config.getString("moderation.defaultMuteReason", "Chat violation");
    }

    public boolean areSilentBans() {
        return this.config.getBoolean("moderation.silentBans", false);
    }

    public boolean shouldObfuscateIPs() {
        return this.config.getBoolean("privacy.obfuscateIPs", false);
    }

    public boolean shouldLogIPs() {
        return this.config.getBoolean("privacy.logIPs", true);
    }

    public int getDataRetentionDays() {
        return this.config.getInt("privacy.dataRetentionDays", 90);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public FileConfiguration getLangConfig() {
        return this.langConfig;
    }
}

