/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.config;

import com.unifiedsecure.UnifiedSecureMgr;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class WebhookConfigManager {
    private final UnifiedSecureMgr plugin;
    private FileConfiguration config;

    public WebhookConfigManager(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        File configFile = new File(this.plugin.getDataFolder(), "webhook-config.yml");
        if (!configFile.exists()) {
            this.plugin.saveResource("webhook-config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
    }

    public boolean isWebhookEnabled(String type) {
        return this.config.getBoolean("webhooks." + type + ".enabled", false);
    }

    public String getWebhookUrl(String type) {
        return this.config.getString("webhooks." + type + ".url", "");
    }

    public String getMentionRole(String type) {
        return this.config.getString("webhooks." + type + ".mentionRole", "");
    }

    public int getRetryAttempts(String type) {
        return this.config.getInt("webhooks." + type + ".retryAttempts", 3);
    }

    public int getRetryDelayMs(String type) {
        return this.config.getInt("webhooks." + type + ".retryDelayMs", 1000);
    }

    public List<String> getLogCategories() {
        return this.config.getStringList("webhooks.logs.categories");
    }

    public String getGlobalUsername() {
        return this.config.getString("global.username", "UnifiedSecureMgr");
    }

    public String getGlobalAvatarUrl() {
        return this.config.getString("global.avatarUrl", "");
    }

    public int getGlobalTimeout() {
        return this.config.getInt("global.timeout", 5000);
    }
}

