/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.coreprotect;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.coreprotect.BlockAction;
import com.unifiedsecure.coreprotect.BlockLogEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;

public class BlockLogger {
    private final UnifiedSecureMgr plugin;

    public BlockLogger(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    public void logBlockPlace(Player player, Block block) {
        BlockLogEntry entry = new BlockLogEntry();
        entry.setAction(BlockAction.PLACE);
        entry.setPlayerId(player.getUniqueId());
        entry.setPlayerName(player.getName());
        entry.setLocation(block.getLocation());
        entry.setMaterial(block.getType());
        entry.setBlockData(block.getBlockData().getAsString());
        entry.setTimestamp(System.currentTimeMillis());
        this.saveEntry(entry);
    }

    public void logBlockBreak(Player player, Block block) {
        BlockLogEntry entry = new BlockLogEntry();
        entry.setAction(BlockAction.BREAK);
        entry.setPlayerId(player.getUniqueId());
        entry.setPlayerName(player.getName());
        entry.setLocation(block.getLocation());
        entry.setMaterial(block.getType());
        entry.setBlockData(block.getBlockData().getAsString());
        entry.setTimestamp(System.currentTimeMillis());
        this.saveEntry(entry);
    }

    public void logInteraction(Player player, Block block, String interactionType) {
        BlockLogEntry entry = new BlockLogEntry();
        entry.setAction(BlockAction.INTERACT);
        entry.setPlayerId(player.getUniqueId());
        entry.setPlayerName(player.getName());
        entry.setLocation(block.getLocation());
        entry.setMaterial(block.getType());
        entry.setBlockData(interactionType);
        entry.setTimestamp(System.currentTimeMillis());
        this.saveEntry(entry);
    }

    private void saveEntry(BlockLogEntry entry) {
        this.plugin.getAsyncUtil().runAsync(() -> {
            if (this.plugin.getStorageProvider() != null) {
                this.plugin.getStorageProvider().saveBlockLog(entry);
            }
        });
    }

    public List<BlockLogEntry> lookup(Location location, int radius, long timeAgo) {
        if (this.plugin.getStorageProvider() == null) {
            return new ArrayList<BlockLogEntry>();
        }
        long startTime = System.currentTimeMillis() - timeAgo;
        return this.plugin.getStorageProvider().lookupBlockLogs(location, radius, startTime);
    }

    public List<BlockLogEntry> lookupPlayer(UUID playerId, long timeAgo) {
        if (this.plugin.getStorageProvider() == null) {
            return new ArrayList<BlockLogEntry>();
        }
        long startTime = System.currentTimeMillis() - timeAgo;
        return this.plugin.getStorageProvider().lookupPlayerBlockLogs(playerId, startTime);
    }

    public void rollback(UUID playerId, long time) {
        this.plugin.getAsyncUtil().runAsync(() -> {
            List<BlockLogEntry> entries = this.lookupPlayer(playerId, time);
            this.plugin.getAsyncUtil().runSync(() -> {
                for (BlockLogEntry entry : entries) {
                    Location loc = entry.getLocation();
                    if (loc.getWorld() == null) continue;
                    Block block = loc.getBlock();
                    if (entry.getAction() == BlockAction.PLACE) {
                        block.setType(Material.AIR);
                        continue;
                    }
                    if (entry.getAction() != BlockAction.BREAK) continue;
                    block.setType(entry.getMaterial());
                    if (entry.getBlockData() == null) continue;
                    try {
                        BlockData data = this.plugin.getServer().createBlockData(entry.getBlockData());
                        block.setBlockData(data);
                    }
                    catch (Exception exception) {}
                }
            });
        });
    }

    public void restore(Location location, int radius, long time) {
        this.plugin.getAsyncUtil().runAsync(() -> {
            List<BlockLogEntry> entries = this.lookup(location, radius, time);
            this.plugin.getAsyncUtil().runSync(() -> {
                for (BlockLogEntry entry : entries) {
                    Location loc = entry.getLocation();
                    if (loc.getWorld() == null) continue;
                    Block block = loc.getBlock();
                    if (entry.getAction() != BlockAction.BREAK) continue;
                    block.setType(entry.getMaterial());
                    if (entry.getBlockData() == null) continue;
                    try {
                        BlockData data = this.plugin.getServer().createBlockData(entry.getBlockData());
                        block.setBlockData(data);
                    }
                    catch (Exception exception) {}
                }
            });
        });
    }
}

