/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.correlation;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.cluster.AccountCluster;
import com.unifiedsecure.correlation.CorrelationEntry;
import com.unifiedsecure.correlation.CorrelationMatch;
import com.unifiedsecure.correlation.CorrelationScore;
import com.unifiedsecure.model.PlayerIPData;
import com.unifiedsecure.model.Punishment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class InfractionsCorrelator {
    private final UnifiedSecureMgr plugin;
    private final Map<String, List<CorrelationEntry>> correlations;

    public InfractionsCorrelator(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.correlations = new ConcurrentHashMap<String, List<CorrelationEntry>>();
    }

    public void analyzePlayer(UUID uuid) {
        this.plugin.getAsyncUtil().runAsync(() -> {
            List<CorrelationMatch> matches = this.findCorrelations(uuid);
            if (!matches.isEmpty()) {
                this.plugin.getAsyncUtil().runSync(() -> this.alertStaff(uuid, matches));
            }
        });
    }

    private List<CorrelationMatch> findCorrelations(UUID uuid) {
        ArrayList<CorrelationMatch> matches = new ArrayList<CorrelationMatch>();
        if (this.plugin.getIPTracker() == null) {
            return matches;
        }
        PlayerIPData playerData = this.plugin.getIPTracker().getPlayerData(uuid);
        if (playerData == null) {
            return matches;
        }
        List<String> ips = playerData.getIpHistory();
        for (String ip : ips) {
            List sharedPlayers = this.plugin.getIPTracker().getPlayersWithIP(ip).stream().map(PlayerIPData::getUuid).collect(Collectors.toList());
            for (UUID otherId : sharedPlayers) {
                CorrelationScore score;
                if (otherId.equals(uuid) || (score = this.calculateCorrelation(uuid, otherId)).getScore() < 50) continue;
                matches.add(new CorrelationMatch(uuid, otherId, score));
            }
        }
        return matches;
    }

    private CorrelationScore calculateCorrelation(UUID player1, UUID player2) {
        long firstPlayed2;
        long firstPlayed1;
        long timeDiff;
        CorrelationScore score = new CorrelationScore();
        PlayerIPData data1 = this.plugin.getIPTracker().getPlayerData(player1);
        PlayerIPData data2 = this.plugin.getIPTracker().getPlayerData(player2);
        if (data1 == null || data2 == null) {
            return score;
        }
        List<String> ips1 = data1.getIpHistory();
        List<String> ips2 = data2.getIpHistory();
        long sharedIPs = ips1.stream().filter(ips2::contains).count();
        if (sharedIPs > 0L) {
            score.addScore(sharedIPs * 20L, "Shared IPs: " + sharedIPs);
        }
        if (this.plugin.getStorageProvider() != null) {
            List<Punishment> punishments1 = this.plugin.getStorageProvider().loadPlayerPunishments(player1);
            List<Punishment> punishments2 = this.plugin.getStorageProvider().loadPlayerPunishments(player2);
            Set reasons1 = punishments1.stream().map(Punishment::getReason).collect(Collectors.toSet());
            Set reasons2 = punishments2.stream().map(Punishment::getReason).collect(Collectors.toSet());
            long sharedReasons = reasons1.stream().filter(reasons2::contains).count();
            if (sharedReasons > 0L) {
                score.addScore(sharedReasons * 10L, "Similar infractions: " + sharedReasons);
            }
        }
        if (this.plugin.getClusterDetector() != null) {
            List<AccountCluster> clusters1 = this.plugin.getClusterDetector().getPlayerClusters(player1);
            List<AccountCluster> clusters2 = this.plugin.getClusterDetector().getPlayerClusters(player2);
            boolean inSameCluster = clusters1.stream().anyMatch(c1 -> clusters2.stream().anyMatch(c2 -> c1.getIdentifier().equals(c2.getIdentifier())));
            if (inSameCluster) {
                score.addScore(30L, "In same account cluster");
            }
        }
        if ((timeDiff = Math.abs((firstPlayed1 = this.plugin.getServer().getOfflinePlayer(player1).getFirstPlayed()) - (firstPlayed2 = this.plugin.getServer().getOfflinePlayer(player2).getFirstPlayed()))) < 3600000L) {
            score.addScore(15L, "Accounts created within 1 hour");
        } else if (timeDiff < 86400000L) {
            score.addScore(10L, "Accounts created within 1 day");
        }
        return score;
    }

    private void alertStaff(UUID uuid, List<CorrelationMatch> matches) {
        String playerName = this.plugin.getServer().getOfflinePlayer(uuid).getName();
        this.plugin.getServer().getOnlinePlayers().stream().filter(p -> p.hasPermission("unified.correlation.alerts")).forEach(p -> {
            p.sendMessage("\u00a7c[Correlation] \u00a7ePlayer \u00a7f" + playerName + " \u00a7ehas " + matches.size() + " correlated accounts:");
            for (CorrelationMatch match : matches) {
                String otherName = this.plugin.getServer().getOfflinePlayer(match.getOtherPlayer()).getName();
                p.sendMessage("  \u00a77- \u00a7f" + otherName + " \u00a77(Score: " + match.getScore().getScore() + ")");
            }
        });
    }

    public List<CorrelationMatch> getCorrelations(UUID uuid) {
        return this.findCorrelations(uuid);
    }
}

