/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.debug;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.debug.ProfilerReport;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class DebugProfiler {
    private final UnifiedSecureMgr plugin;
    private final Map<String, ProfilerEntry> metrics;
    private final Map<String, AtomicLong> counters;
    private boolean enabled;

    public DebugProfiler(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.metrics = new ConcurrentHashMap<String, ProfilerEntry>();
        this.counters = new ConcurrentHashMap<String, AtomicLong>();
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
        this.plugin.getLogger().info("Debug profiler enabled");
    }

    public void disable() {
        this.enabled = false;
        this.plugin.getLogger().info("Debug profiler disabled");
    }

    public void startTiming(String name) {
        if (!this.enabled) {
            return;
        }
        this.metrics.put(name, new ProfilerEntry(System.nanoTime()));
    }

    public void stopTiming(String name) {
        if (!this.enabled) {
            return;
        }
        ProfilerEntry entry = this.metrics.get(name);
        if (entry != null) {
            entry.stop();
        }
    }

    public void increment(String counter) {
        if (!this.enabled) {
            return;
        }
        this.counters.computeIfAbsent(counter, k -> new AtomicLong()).incrementAndGet();
    }

    public void recordMemory(String label) {
        if (!this.enabled) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long used = (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L;
        this.metrics.put(label + "_memory", new ProfilerEntry(used));
    }

    public ProfilerReport generateReport() {
        ProfilerReport report = new ProfilerReport();
        for (Map.Entry<String, ProfilerEntry> entry : this.metrics.entrySet()) {
            report.addMetric(entry.getKey(), entry.getValue().getDuration());
        }
        for (Map.Entry<String, Object> entry : this.counters.entrySet()) {
            report.addCounter(entry.getKey(), ((AtomicLong)entry.getValue()).get());
        }
        Runtime runtime = Runtime.getRuntime();
        report.setTotalMemory(runtime.totalMemory() / 0x100000L);
        report.setFreeMemory(runtime.freeMemory() / 0x100000L);
        report.setUsedMemory((runtime.totalMemory() - runtime.freeMemory()) / 0x100000L);
        report.setMaxMemory(runtime.maxMemory() / 0x100000L);
        report.setThreadCount(Thread.activeCount());
        report.setUptime(this.plugin.getUptime());
        return report;
    }

    public void reset() {
        this.metrics.clear();
        this.counters.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static class ProfilerEntry {
        private final long startTime;
        private long endTime;
        private long value;

        public ProfilerEntry(long startTime) {
            this.startTime = startTime;
            this.endTime = 0L;
        }

        public void stop() {
            this.endTime = System.nanoTime();
        }

        public long getDuration() {
            if (this.endTime == 0L) {
                return System.nanoTime() - this.startTime;
            }
            return this.endTime - this.startTime;
        }
    }
}

