/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.discord;

import com.unifiedsecure.UnifiedSecureMgr;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DiscordWebhookClient {
    private final UnifiedSecureMgr plugin;
    private final Map<String, String> webhookUrls;
    private final ConcurrentLinkedQueue<WebhookMessage> messageQueue;
    private boolean enabled;

    public DiscordWebhookClient(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.webhookUrls = new HashMap<String, String>();
        this.messageQueue = new ConcurrentLinkedQueue();
        this.enabled = plugin.getConfig().getBoolean("discord.enabled", false);
        this.loadWebhooks();
        this.startQueueProcessor();
    }

    private void loadWebhooks() {
        if (!this.enabled) {
            return;
        }
        this.webhookUrls.put("alerts", this.plugin.getConfig().getString("discord.webhooks.alerts", ""));
        this.webhookUrls.put("bans", this.plugin.getConfig().getString("discord.webhooks.bans", ""));
        this.webhookUrls.put("security", this.plugin.getConfig().getString("discord.webhooks.security", ""));
    }

    public void sendMessage(String channel, String content) {
        if (!this.enabled || !this.webhookUrls.containsKey(channel)) {
            return;
        }
        this.messageQueue.offer(new WebhookMessage(channel, content));
    }

    public void sendEmbed(String channel, String title, String description, int color) {
        if (!this.enabled || !this.webhookUrls.containsKey(channel)) {
            return;
        }
        String json = this.buildEmbedJson(title, description, color);
        this.messageQueue.offer(new WebhookMessage(channel, json, true));
    }

    public void sendBanNotification(String targetName, String issuerName, String reason, String duration) {
        if (!this.enabled) {
            return;
        }
        String title = "Player Banned";
        String description = String.format("**Player:** %s\n**Banned by:** %s\n**Reason:** %s\n**Duration:** %s", targetName, issuerName, reason, duration);
        this.sendEmbed("bans", title, description, 0xFF0000);
    }

    public void sendUnbanNotification(String targetName, String remover) {
        if (!this.enabled) {
            return;
        }
        String title = "Player Unbanned";
        String description = String.format("**Player:** %s\n**Unbanned by:** %s", targetName, remover);
        this.sendEmbed("bans", title, description, 65280);
    }

    private String buildEmbedJson(String title, String description, int color) {
        return String.format("{\"embeds\":[{\"title\":\"%s\",\"description\":\"%s\",\"color\":%d}]}", this.escapeJson(title), this.escapeJson(description), color);
    }

    private String escapeJson(String text) {
        return text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }

    private void startQueueProcessor() {
        new BukkitRunnable(){

            public void run() {
                while (!DiscordWebhookClient.this.messageQueue.isEmpty()) {
                    WebhookMessage msg = DiscordWebhookClient.this.messageQueue.poll();
                    if (msg == null) continue;
                    DiscordWebhookClient.this.sendWebhook(msg);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 20L, 20L);
    }

    private void sendWebhook(WebhookMessage message) {
        String webhookUrl = this.webhookUrls.get(message.channel);
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        try {
            URL url = new URL(webhookUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            String jsonPayload = message.isEmbed ? message.content : String.format("{\"content\":\"%s\"}", this.escapeJson(message.content));
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 200 && responseCode != 204) {
                this.plugin.getLogger().warning("Discord webhook returned code: " + responseCode);
            }
            connection.disconnect();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to send Discord webhook: " + e.getMessage());
        }
    }

    public void shutdown() {
        while (!this.messageQueue.isEmpty()) {
            WebhookMessage msg = this.messageQueue.poll();
            if (msg == null) continue;
            this.sendWebhook(msg);
        }
    }

    private static class WebhookMessage {
        String channel;
        String content;
        boolean isEmbed;

        WebhookMessage(String channel, String content) {
            this(channel, content, false);
        }

        WebhookMessage(String channel, String content, boolean isEmbed) {
            this.channel = channel;
            this.content = content;
            this.isEmbed = isEmbed;
        }
    }
}

