/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.geoip;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.unifiedsecure.UnifiedSecureMgr;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.plugin.Plugin;

public class GeoIPService {
    private final UnifiedSecureMgr plugin;
    private final Map<String, GeoIPData> cache;
    private long lastRequestTime;

    public GeoIPService(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.cache = new ConcurrentHashMap<String, GeoIPData>();
        this.lastRequestTime = 0L;
    }

    public void lookupAsync(String ip, GeoIPCallback callback) {
        this.plugin.getAsyncUtil().runAsync(() -> {
            GeoIPData data = this.lookup(ip);
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> callback.onComplete(data));
        });
    }

    public GeoIPData lookup(String ip) {
        long cooldown;
        long now;
        if (this.cache.containsKey(ip)) {
            GeoIPData cached = this.cache.get(ip);
            if (System.currentTimeMillis() - cached.getCacheTime() < (long)this.plugin.getConfigManager().getGeoIPCacheTTLMinutes() * 60000L) {
                return cached;
            }
        }
        if ((now = System.currentTimeMillis()) - this.lastRequestTime < (cooldown = this.plugin.getConfigManager().getGeoIPCooldownMs())) {
            try {
                Thread.sleep(cooldown - (now - this.lastRequestTime));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        try {
            String urlString = this.plugin.getConfigManager().getGeoIPProviderUrl().replace("{ip}", ip);
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            this.lastRequestTime = System.currentTimeMillis();
            if (conn.getResponseCode() == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                JsonObject json = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                if (json.has("status") && json.get("status").getAsString().equals("success")) {
                    GeoIPData data = new GeoIPData(ip, json.has("country") ? json.get("country").getAsString() : "Unknown", json.has("countryCode") ? json.get("countryCode").getAsString() : "??", json.has("region") ? json.get("region").getAsString() : "Unknown", json.has("city") ? json.get("city").getAsString() : "Unknown", json.has("isp") ? json.get("isp").getAsString() : "Unknown", System.currentTimeMillis());
                    this.cache.put(ip, data);
                    return data;
                }
            }
            conn.disconnect();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to lookup GeoIP for " + ip + ": " + e.getMessage());
        }
        return new GeoIPData(ip, "Unknown", "??", "Unknown", "Unknown", "Unknown", System.currentTimeMillis());
    }

    public static interface GeoIPCallback {
        public void onComplete(GeoIPData var1);
    }

    public static class GeoIPData {
        private final String ip;
        private final String country;
        private final String countryCode;
        private final String region;
        private final String city;
        private final String isp;
        private final long cacheTime;

        public GeoIPData(String ip, String country, String countryCode, String region, String city, String isp, long cacheTime) {
            this.ip = ip;
            this.country = country;
            this.countryCode = countryCode;
            this.region = region;
            this.city = city;
            this.isp = isp;
            this.cacheTime = cacheTime;
        }

        public String getIp() {
            return this.ip;
        }

        public String getCountry() {
            return this.country;
        }

        public String getCountryCode() {
            return this.countryCode;
        }

        public String getRegion() {
            return this.region;
        }

        public String getCity() {
            return this.city;
        }

        public String getIsp() {
            return this.isp;
        }

        public long getCacheTime() {
            return this.cacheTime;
        }

        public String getFormatted() {
            return this.city + ", " + this.region + ", " + this.country + " (" + this.countryCode + ") - ISP: " + this.isp;
        }
    }
}

