/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.ip;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.model.IPBan;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BanManager {
    private final UnifiedSecureMgr plugin;
    private final Map<String, IPBan> ipBanCache;

    public BanManager(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.ipBanCache = new ConcurrentHashMap<String, IPBan>();
        this.loadAllBans();
    }

    private void loadAllBans() {
        this.plugin.getAsyncUtil().runAsync(() -> {
            List<IPBan> allBans = this.plugin.getStorageProvider().loadAllIPBans();
            allBans.forEach(ban -> this.ipBanCache.put(ban.getIp(), (IPBan)ban));
            this.plugin.getLogger().info("Loaded " + allBans.size() + " IP bans.");
        });
    }

    public void banIP(String ip, String reason, String bannedBy, long duration) {
        long bannedAt = System.currentTimeMillis();
        long expiresAt = duration > 0L ? bannedAt + duration : 0L;
        boolean permanent = duration == 0L;
        IPBan ban = new IPBan(ip, reason, bannedBy, bannedAt, expiresAt, permanent);
        this.ipBanCache.put(ip, ban);
        this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().saveIPBan(ban));
        this.kickPlayersWithIP(ip, reason);
        if (this.plugin.getConfigManager().shouldBroadcastBansToStaff()) {
            this.broadcastToStaff(this.plugin.getConfigManager().getMessage("ipban.broadcast").replace("%ip%", ip).replace("%reason%", reason).replace("%staff%", bannedBy));
        }
    }

    public void unbanIP(String ip) {
        this.ipBanCache.remove(ip);
        this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().removeIPBan(ip));
    }

    public boolean isIPBanned(String ip) {
        IPBan ban = this.ipBanCache.get(ip);
        if (ban == null) {
            return false;
        }
        if (ban.isPermanent()) {
            return true;
        }
        if (ban.getExpiresAt() > System.currentTimeMillis()) {
            return true;
        }
        this.unbanIP(ip);
        return false;
    }

    public IPBan getIPBan(String ip) {
        return this.ipBanCache.get(ip);
    }

    public List<IPBan> getAllBans() {
        return List.copyOf(this.ipBanCache.values());
    }

    public void kickPlayersWithIP(String ip, String reason) {
        String kickMessage = this.plugin.getConfigManager().getIPBanKickMessage().replace("%reason%", reason);
        for (Player player : Bukkit.getOnlinePlayers()) {
            String playerIP = this.plugin.getIPTracker().getPlayerIP(player);
            if (playerIP == null || !playerIP.equals(ip)) continue;
            if (this.plugin.getConfigManager().isSilentKick()) {
                player.kickPlayer(kickMessage);
                continue;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> player.kickPlayer(kickMessage));
        }
    }

    private void broadcastToStaff(String message) {
        Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("unified.staff")).forEach(p -> p.sendMessage(message));
    }

    public void saveAll() {
        this.plugin.getAsyncUtil().runAsync(() -> this.ipBanCache.values().forEach(ban -> this.plugin.getStorageProvider().saveIPBan((IPBan)ban)));
    }
}

