/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.ip;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.model.PlayerIPData;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class IPTracker {
    private final UnifiedSecureMgr plugin;
    private final Map<UUID, PlayerIPData> ipDataCache;

    public IPTracker(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.ipDataCache = new ConcurrentHashMap<UUID, PlayerIPData>();
        this.loadAllData();
    }

    private void loadAllData() {
        this.plugin.getAsyncUtil().runAsync(() -> {
            List<PlayerIPData> allData = this.plugin.getStorageProvider().loadAllPlayerIPData();
            allData.forEach(data -> this.ipDataCache.put(data.getUuid(), (PlayerIPData)data));
            this.plugin.getLogger().info("Loaded " + allData.size() + " player IP records.");
        });
    }

    public void trackPlayer(Player player) {
        UUID uuid = player.getUniqueId();
        String username = player.getName();
        String ip = this.getPlayerIP(player);
        if (ip == null) {
            return;
        }
        PlayerIPData data = this.ipDataCache.computeIfAbsent(uuid, k -> new PlayerIPData(uuid, username));
        data.setUsername(username);
        data.setCurrentIP(ip);
        data.addIP(ip);
        long now = System.currentTimeMillis();
        if (data.getFirstJoin() == 0L) {
            data.setFirstJoin(now);
        }
        data.setLastJoin(now);
        this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().savePlayerIPData(data));
    }

    public PlayerIPData getPlayerData(UUID uuid) {
        return this.ipDataCache.get(uuid);
    }

    public PlayerIPData getPlayerData(String username) {
        return this.ipDataCache.values().stream().filter(data -> data.getUsername().equalsIgnoreCase(username)).findFirst().orElse(null);
    }

    public List<PlayerIPData> getPlayersWithIP(String ip) {
        return this.ipDataCache.values().stream().filter(data -> data.getIpHistory().contains(ip)).collect(Collectors.toList());
    }

    public List<String> getSharedIPs(UUID uuid1, UUID uuid2) {
        PlayerIPData data1 = this.ipDataCache.get(uuid1);
        PlayerIPData data2 = this.ipDataCache.get(uuid2);
        if (data1 == null || data2 == null) {
            return Collections.emptyList();
        }
        ArrayList<String> shared = new ArrayList<String>(data1.getIpHistory());
        shared.retainAll(data2.getIpHistory());
        return shared;
    }

    public Map<UUID, List<String>> findAllSharedIPs(UUID uuid) {
        PlayerIPData targetData = this.ipDataCache.get(uuid);
        if (targetData == null) {
            return Collections.emptyMap();
        }
        HashMap<UUID, List<String>> sharedMap = new HashMap<UUID, List<String>>();
        for (PlayerIPData otherData : this.ipDataCache.values()) {
            if (otherData.getUuid().equals(uuid)) continue;
            ArrayList<String> shared = new ArrayList<String>(targetData.getIpHistory());
            shared.retainAll(otherData.getIpHistory());
            if (shared.isEmpty()) continue;
            sharedMap.put(otherData.getUuid(), shared);
        }
        return sharedMap;
    }

    public void deletePlayerData(UUID uuid) {
        this.ipDataCache.remove(uuid);
        this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().deletePlayerIPData(uuid));
    }

    public void saveAll() {
        this.plugin.getAsyncUtil().runAsync(() -> this.ipDataCache.values().forEach(data -> this.plugin.getStorageProvider().savePlayerIPData((PlayerIPData)data)));
    }

    public String getPlayerIP(Player player) {
        InetSocketAddress address = player.getAddress();
        if (address == null) {
            return null;
        }
        String ip = address.getAddress().getHostAddress();
        if (this.plugin.getConfigManager().shouldObfuscateIPs()) {
            return this.obfuscateIP(ip);
        }
        return ip;
    }

    private String obfuscateIP(String ip) {
        String[] parts = ip.split("\\.");
        if (parts.length == 4) {
            return parts[0] + "." + parts[1] + ".***." + parts[3];
        }
        return ip;
    }

    public Map<UUID, PlayerIPData> getAllData() {
        return new HashMap<UUID, PlayerIPData>(this.ipDataCache);
    }
}

