/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.listeners;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.chat.FilterResult;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ComprehensiveListener
implements Listener {
    private final UnifiedSecureMgr plugin;

    public ComprehensiveListener(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getVanishManager() != null) {
            this.plugin.getVanishManager().handleJoin(player);
        }
        if (this.plugin.getTrustSystem() != null) {
            this.plugin.getTrustSystem().initializePlayer(player.getUniqueId());
        }
        if (this.plugin.getRiskAlertSystem() != null) {
            this.plugin.getRiskAlertSystem().analyzePlayer(player);
        }
        if (this.plugin.getInfractionsCorrelator() != null) {
            this.plugin.getInfractionsCorrelator().analyzePlayer(player.getUniqueId());
        }
        if (this.plugin.getVPNDetector() != null && this.plugin.getConfigManager().getConfig().getBoolean("vpn.checkOnJoin", true)) {
            String ip = player.getAddress().getAddress().getHostAddress();
            this.plugin.getVPNDetector().checkAsync(ip, result -> {
                if (result.isSuspicious()) {
                    this.plugin.getServer().getOnlinePlayers().stream().filter(p -> p.hasPermission("unified.vpn.alerts")).forEach(p -> p.sendMessage("\u00a7c[VPN] " + player.getName() + " joined with suspicious IP"));
                    if (this.plugin.getConfigManager().getConfig().getBoolean("vpn.kickOnDetection", false)) {
                        player.kickPlayer("\u00a7cVPN/Proxy detected. Please disable and reconnect.");
                    }
                }
            });
        }
        String hardwareId = player.getClientBrandName();
        if (this.plugin.getClusterDetector() != null) {
            String ip = player.getAddress().getAddress().getHostAddress();
            this.plugin.getClusterDetector().addToCluster(player.getUniqueId(), ip, hardwareId);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin.getFreezeManager() != null) {
            this.plugin.getFreezeManager().handleQuit(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getChatFilter() != null) {
            FilterResult result = this.plugin.getChatFilter().filter(player, event.getMessage());
            if (result.isBlocked()) {
                event.setCancelled(true);
                return;
            }
            if (result.wasFiltered()) {
                event.setMessage(result.getFilteredMessage());
            }
        }
        if (this.plugin.getStressDetector() != null) {
            this.plugin.getStressDetector().recordChat(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String command = event.getMessage().substring(1);
        if (this.plugin.getCommandSpy() != null) {
            this.plugin.getCommandSpy().broadcast(player, command);
        }
        if (this.plugin.getStressDetector() != null) {
            this.plugin.getStressDetector().recordCommand(player, command);
        }
        if (this.plugin.getTrustSystem() != null) {
            this.plugin.getTrustSystem().recordPositiveAction(player.getUniqueId(), "COMMAND_USE");
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.plugin.getFreezeManager() != null && this.plugin.getFreezeManager().isFrozen(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.plugin.getBlockLogger() != null) {
            this.plugin.getBlockLogger().logBlockPlace(event.getPlayer(), event.getBlock());
        }
        if (this.plugin.getTrustSystem() != null) {
            this.plugin.getTrustSystem().recordPositiveAction(event.getPlayer().getUniqueId(), "BLOCK_PLACE");
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.plugin.getBlockLogger() != null) {
            this.plugin.getBlockLogger().logBlockBreak(event.getPlayer(), event.getBlock());
        }
        if (this.plugin.getTrustSystem() != null) {
            this.plugin.getTrustSystem().recordPositiveAction(event.getPlayer().getUniqueId(), "BLOCK_BREAK");
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (event.getPlayer() instanceof Player) {
            Player player = (Player)event.getPlayer();
            if (this.plugin.getVanishManager() != null && this.plugin.getVanishManager().hasSilentChest(player.getUniqueId())) {
                event.setCancelled(false);
            }
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (this.plugin.getVanishManager() != null && this.plugin.getVanishManager().hasNoPickup(player.getUniqueId())) {
                event.setCancelled(true);
            }
        }
    }
}

