/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.listeners;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.model.LogEntry;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class LoggingListener
implements Listener {
    private final UnifiedSecureMgr plugin;

    public LoggingListener(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        LogEntry entry = new LogEntry(System.currentTimeMillis(), player.getUniqueId(), player.getName(), "JOIN", "Player joined the server", player.getWorld().getName(), player.getLocation().getX(), player.getLocation().getY(), player.getLocation().getZ());
        this.plugin.getStorageProvider().saveLogEntry(entry);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        LogEntry entry = new LogEntry(System.currentTimeMillis(), player.getUniqueId(), player.getName(), "QUIT", "Player left the server", player.getWorld().getName(), player.getLocation().getX(), player.getLocation().getY(), player.getLocation().getZ());
        this.plugin.getStorageProvider().saveLogEntry(entry);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        LogEntry entry = new LogEntry(System.currentTimeMillis(), player.getUniqueId(), player.getName(), "COMMAND", event.getMessage(), player.getWorld().getName(), player.getLocation().getX(), player.getLocation().getY(), player.getLocation().getZ());
        this.plugin.getStorageProvider().saveLogEntry(entry);
    }
}

