/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.listeners;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.model.Punishment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;

public class ModerationListener
implements Listener {
    private final UnifiedSecureMgr plugin;

    public ModerationListener(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        Punishment ban;
        if (this.plugin.getPunishmentManager() == null) {
            return;
        }
        if (this.plugin.getPunishmentManager().isBanned(event.getUniqueId()) && (ban = this.plugin.getPunishmentManager().getActiveBan(event.getUniqueId())) != null) {
            String message = this.plugin.getPunishmentManager().formatBanMessage(ban, ban.getIssuerName());
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, message);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (this.plugin.getPunishmentManager() == null) {
            return;
        }
        if (this.plugin.getPunishmentManager().isMuted(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
            Punishment mute = this.plugin.getPunishmentManager().getActiveMute(event.getPlayer().getUniqueId());
            if (mute != null) {
                event.getPlayer().sendMessage("\u00a7cYou are muted!");
                event.getPlayer().sendMessage("\u00a77Reason: \u00a7f" + mute.getReason());
                if (!mute.isPermanent()) {
                    long remaining = mute.getExpiresAt() - System.currentTimeMillis();
                    event.getPlayer().sendMessage("\u00a77Expires in: \u00a7f" + this.plugin.getPunishmentManager().formatDuration(remaining));
                } else {
                    event.getPlayer().sendMessage("\u00a77Duration: \u00a7fPermanent");
                }
            } else {
                event.getPlayer().sendMessage("\u00a7cYou are muted!");
            }
        }
    }
}

