/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.logging;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.logging.LoggerService;
import java.io.File;
import java.util.Arrays;

public class LogRotationTask
implements Runnable {
    private final UnifiedSecureMgr plugin;
    private final LoggerService loggerService;
    private final int maxLogDays;

    public LogRotationTask(UnifiedSecureMgr plugin, int maxLogDays) {
        this.plugin = plugin;
        this.loggerService = plugin.getLoggerService();
        this.maxLogDays = maxLogDays;
    }

    public LogRotationTask(UnifiedSecureMgr plugin, LoggerService loggerService) {
        this.plugin = plugin;
        this.loggerService = loggerService;
        this.maxLogDays = plugin.getConfig().getInt("logging.max-log-days", 30);
    }

    @Override
    public void run() {
        File logDir = this.loggerService.getLogDirectory();
        if (!logDir.exists() || !logDir.isDirectory()) {
            return;
        }
        File[] logFiles = logDir.listFiles((dir, name) -> name.endsWith(".log"));
        if (logFiles == null || logFiles.length == 0) {
            return;
        }
        long maxAge = System.currentTimeMillis() - (long)this.maxLogDays * 24L * 60L * 60L * 1000L;
        Arrays.stream(logFiles).filter(file -> file.lastModified() < maxAge).forEach(file -> {
            if (file.delete()) {
                this.plugin.getLogger().info("Deleted old log file: " + file.getName());
            }
        });
    }
}

