/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.logging;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.model.LogEntry;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.plugin.Plugin;

public class LoggerService {
    private final UnifiedSecureMgr plugin;
    private final File logDirectory;
    private final Queue<LogEntry> logQueue;
    private final SimpleDateFormat dateFormat;
    private PrintWriter currentLogWriter;
    private String currentLogFile;

    public LoggerService(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.logDirectory = new File(plugin.getDataFolder(), "logs");
        this.logQueue = new ConcurrentLinkedQueue<LogEntry>();
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (!this.logDirectory.exists()) {
            this.logDirectory.mkdirs();
        }
        this.openLogFile();
        this.startLogProcessor();
    }

    private void openLogFile() {
        String fileName = "security-" + this.dateFormat.format(new Date()) + ".log";
        File logFile = new File(this.logDirectory, fileName);
        if (!fileName.equals(this.currentLogFile)) {
            this.closeLogFile();
            try {
                this.currentLogWriter = new PrintWriter(new FileWriter(logFile, true));
                this.currentLogFile = fileName;
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to open log file: " + e.getMessage());
            }
        }
    }

    private void closeLogFile() {
        if (this.currentLogWriter != null) {
            this.currentLogWriter.close();
            this.currentLogWriter = null;
        }
    }

    public void log(LogEntry entry) {
        this.logQueue.offer(entry);
        this.plugin.getStorageProvider().saveLogEntry(entry);
    }

    public void logSecurity(String action, String details) {
        LogEntry entry = new LogEntry(null, "SYSTEM", LogEntry.LogType.SECURITY, action, details);
        this.log(entry);
    }

    public void logChat(UUID playerUuid, String message, String details) {
        LogEntry entry = new LogEntry(playerUuid, this.plugin.getServer().getOfflinePlayer(playerUuid).getName(), LogEntry.LogType.CHAT, "CHAT", message + " | " + details);
        this.log(entry);
    }

    public void logStaff(UUID staffUuid, String action, String details) {
        LogEntry entry = new LogEntry(staffUuid, this.plugin.getServer().getOfflinePlayer(staffUuid).getName(), LogEntry.LogType.SECURITY, action, details);
        this.log(entry);
    }

    public void logMetric(String metricName, double value) {
        LogEntry entry = new LogEntry(null, "SYSTEM", LogEntry.LogType.SECURITY, "METRIC", metricName + ": " + value);
        this.log(entry);
    }

    public void logMetric(String metricName, long value) {
        LogEntry entry = new LogEntry(null, "SYSTEM", LogEntry.LogType.SECURITY, "METRIC", metricName + ": " + value);
        this.log(entry);
    }

    public void reload() {
        this.closeLogFile();
        this.openLogFile();
    }

    private void startLogProcessor() {
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            while (!this.logQueue.isEmpty()) {
                LogEntry entry = this.logQueue.poll();
                if (entry == null) continue;
                this.writeToFile(entry);
            }
        }, 20L, 20L);
    }

    private void writeToFile(LogEntry entry) {
        this.openLogFile();
        if (this.currentLogWriter != null) {
            SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String logLine = String.format("[%s] [%s] %s - %s: %s", new Object[]{timeFormat.format(new Date(entry.getTimestamp())), entry.getType(), entry.getPlayerName(), entry.getAction(), entry.getDetails()});
            this.currentLogWriter.println(logLine);
            this.currentLogWriter.flush();
        }
    }

    public void shutdown() {
        while (!this.logQueue.isEmpty()) {
            LogEntry entry = this.logQueue.poll();
            if (entry == null) continue;
            this.writeToFile(entry);
        }
        this.closeLogFile();
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }
}

