/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.model;

import java.util.UUID;

public class LogEntry {
    private String id = UUID.randomUUID().toString();
    private UUID playerUUID;
    private String playerName;
    private LogType type;
    private String action;
    private String details;
    private long timestamp;
    private String server;
    private String world;
    private double x;
    private double y;
    private double z;

    public LogEntry(long timestamp, UUID playerUUID, String playerName, String action, String details, String world, double x, double y, double z) {
        this.timestamp = timestamp;
        this.playerUUID = playerUUID;
        this.playerName = playerName;
        this.action = action;
        this.details = details;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = LogType.SECURITY;
    }

    public LogEntry(UUID playerUUID, String playerName, LogType type, String action, String details) {
        this.playerUUID = playerUUID;
        this.playerName = playerName;
        this.type = type;
        this.action = action;
        this.details = details;
        this.timestamp = System.currentTimeMillis();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public UUID getPlayerUuid() {
        return this.playerUUID;
    }

    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public LogType getType() {
        return this.type;
    }

    public void setType(LogType type) {
        this.type = type;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public static enum LogType {
        JOIN,
        QUIT,
        COMMAND,
        CHAT,
        PUNISHMENT,
        BLOCK,
        ITEM,
        DEATH,
        TELEPORT,
        SECURITY;

    }
}

