/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PlayerIPData {
    private UUID uuid;
    private String username;
    private List<String> ipAddresses;
    private String currentIP;
    private long firstJoin;
    private long lastJoin;
    private Map<String, Long> ipUsageTimestamps;

    public PlayerIPData(UUID uuid, String username) {
        this.uuid = uuid;
        this.username = username;
        this.ipAddresses = new ArrayList<String>();
        this.ipUsageTimestamps = new HashMap<String, Long>();
        this.lastJoin = this.firstJoin = System.currentTimeMillis();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public List<String> getIpHistory() {
        return this.ipAddresses;
    }

    public void setIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    public String getCurrentIP() {
        return this.currentIP;
    }

    public void setCurrentIP(String currentIP) {
        this.currentIP = currentIP;
    }

    public long getFirstJoin() {
        return this.firstJoin;
    }

    public void setFirstJoin(long firstJoin) {
        this.firstJoin = firstJoin;
    }

    public long getLastJoin() {
        return this.lastJoin;
    }

    public void setLastJoin(long lastJoin) {
        this.lastJoin = lastJoin;
    }

    public Map<String, Long> getIpUsageTimestamps() {
        return this.ipUsageTimestamps;
    }

    public void setIpUsageTimestamps(Map<String, Long> ipUsageTimestamps) {
        this.ipUsageTimestamps = ipUsageTimestamps;
    }

    public void addIP(String ip) {
        if (!this.ipAddresses.contains(ip)) {
            this.ipAddresses.add(ip);
        }
        this.ipUsageTimestamps.put(ip, System.currentTimeMillis());
    }
}

