/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.model;

import java.util.UUID;

public class PlaytimeData {
    private UUID uuid;
    private String username;
    private long totalPlaytime;
    private long sessionStart;
    private long lastSeen;
    private long lastActivity;
    private boolean online;
    private int sessionCount;

    public PlaytimeData(UUID uuid, String username) {
        this.uuid = uuid;
        this.username = username;
        this.totalPlaytime = 0L;
        this.sessionCount = 0;
        this.lastSeen = System.currentTimeMillis();
        this.lastActivity = System.currentTimeMillis();
        this.online = false;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public long getTotalPlaytime() {
        return this.totalPlaytime;
    }

    public void setTotalPlaytime(long totalPlaytime) {
        this.totalPlaytime = totalPlaytime;
    }

    public long getSessionStart() {
        return this.sessionStart;
    }

    public void setSessionStart(long sessionStart) {
        this.sessionStart = sessionStart;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public void setLastActivity(long lastActivity) {
        this.lastActivity = lastActivity;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public int getSessionCount() {
        return this.sessionCount;
    }

    public void setSessionCount(int sessionCount) {
        this.sessionCount = sessionCount;
    }

    public void addPlaytime(long amount) {
        this.totalPlaytime += amount;
    }

    public void startSession() {
        this.sessionStart = System.currentTimeMillis();
        ++this.sessionCount;
        this.online = true;
    }

    public void endSession() {
        if (this.sessionStart > 0L) {
            long sessionTime = System.currentTimeMillis() - this.sessionStart;
            this.totalPlaytime += sessionTime;
            this.sessionStart = 0L;
        }
        this.lastSeen = System.currentTimeMillis();
        this.online = false;
    }
}

