/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.model;

import java.util.UUID;

public class Punishment {
    private String id;
    private UUID targetUUID;
    private String targetName;
    private UUID issuerUUID;
    private String issuerName;
    private PunishmentType type;
    private String reason;
    private long timestamp;
    private long issuedAt;
    private long duration;
    private long expiryTime;
    private long expiresAt;
    private boolean active;
    private boolean removed;
    private String removedBy;
    private long removedAt;
    private String removalReason;

    public Punishment(String id, UUID targetUUID, String targetName, UUID issuerUUID, String issuerName, PunishmentType type, String reason, long duration) {
        this.id = id;
        this.targetUUID = targetUUID;
        this.targetName = targetName;
        this.issuerUUID = issuerUUID;
        this.issuerName = issuerName;
        this.type = type;
        this.reason = reason;
        this.issuedAt = this.timestamp = System.currentTimeMillis();
        this.duration = duration;
        this.expiresAt = this.expiryTime = duration > 0L ? this.timestamp + duration : -1L;
        this.active = true;
        this.removed = false;
    }

    public Punishment(String id, UUID targetUUID, String targetName, PunishmentType type, String reason, UUID issuerUUID, String issuerName, long issuedAt, long expiresAt) {
        this.id = id;
        this.targetUUID = targetUUID;
        this.targetName = targetName;
        this.issuerUUID = issuerUUID;
        this.issuerName = issuerName;
        this.type = type;
        this.reason = reason;
        this.timestamp = issuedAt;
        this.issuedAt = issuedAt;
        this.expiresAt = expiresAt;
        this.expiryTime = expiresAt;
        this.duration = expiresAt > 0L ? expiresAt - issuedAt : -1L;
        this.active = true;
        this.removed = false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UUID getTargetUUID() {
        return this.targetUUID;
    }

    public UUID getTargetUuid() {
        return this.targetUUID;
    }

    public void setTargetUUID(UUID targetUUID) {
        this.targetUUID = targetUUID;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public UUID getIssuerUUID() {
        return this.issuerUUID;
    }

    public UUID getIssuerUuid() {
        return this.issuerUUID;
    }

    public void setIssuerUUID(UUID issuerUUID) {
        this.issuerUUID = issuerUUID;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }

    public PunishmentType getType() {
        return this.type;
    }

    public void setType(PunishmentType type) {
        this.type = type;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(long issuedAt) {
        this.issuedAt = issuedAt;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(long expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public String getRemovedBy() {
        return this.removedBy;
    }

    public void setRemovedBy(String removedBy) {
        this.removedBy = removedBy;
    }

    public long getRemovedAt() {
        return this.removedAt;
    }

    public void setRemovedAt(long removedAt) {
        this.removedAt = removedAt;
    }

    public String getRemovalReason() {
        return this.removalReason;
    }

    public void setRemovalReason(String removalReason) {
        this.removalReason = removalReason;
    }

    public boolean isPermanent() {
        return this.duration <= 0L;
    }

    public boolean isExpired() {
        return !this.isPermanent() && this.expiryTime > 0L && System.currentTimeMillis() > this.expiryTime;
    }

    public static enum PunishmentType {
        BAN,
        TEMPBAN,
        MUTE,
        TEMPMUTE,
        KICK,
        WARN;

    }
}

