/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.moderation;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.model.Punishment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PunishmentManager {
    private final UnifiedSecureMgr plugin;
    private final Map<UUID, List<Punishment>> activeBans;
    private final Map<UUID, List<Punishment>> activeMutes;
    private final Map<UUID, List<Punishment>> punishmentCache;

    public PunishmentManager(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.activeBans = new ConcurrentHashMap<UUID, List<Punishment>>();
        this.activeMutes = new ConcurrentHashMap<UUID, List<Punishment>>();
        this.punishmentCache = new ConcurrentHashMap<UUID, List<Punishment>>();
        this.loadActivePunishments();
    }

    private void loadActivePunishments() {
        this.plugin.getAsyncUtil().runAsync(() -> {
            List<Punishment> active = this.plugin.getStorageProvider().loadActivePunishments();
            for (Punishment punishment : active) {
                if (punishment.isExpired()) {
                    punishment.setActive(false);
                    this.plugin.getStorageProvider().updatePunishment(punishment);
                    continue;
                }
                if (punishment.getType() == Punishment.PunishmentType.BAN || punishment.getType() == Punishment.PunishmentType.TEMPBAN) {
                    this.activeBans.computeIfAbsent(punishment.getTargetUuid(), k -> new ArrayList()).add(punishment);
                    continue;
                }
                if (punishment.getType() != Punishment.PunishmentType.MUTE && punishment.getType() != Punishment.PunishmentType.TEMPMUTE) continue;
                this.activeMutes.computeIfAbsent(punishment.getTargetUuid(), k -> new ArrayList()).add(punishment);
            }
        });
    }

    public void ban(UUID targetUuid, String targetName, UUID issuerUuid, String issuerName, String reason, long duration) {
        String id = UUID.randomUUID().toString();
        Punishment.PunishmentType type = duration > 0L ? Punishment.PunishmentType.TEMPBAN : Punishment.PunishmentType.BAN;
        Punishment punishment = new Punishment(id, targetUuid, targetName, issuerUuid, issuerName, type, reason, duration);
        this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().savePunishment(punishment));
        this.activeBans.computeIfAbsent(targetUuid, k -> new ArrayList()).add(punishment);
        Player target = Bukkit.getPlayer((UUID)targetUuid);
        if (target != null && target.isOnline()) {
            String kickMessage = this.formatBanMessage(punishment, issuerName);
            this.plugin.getAsyncUtil().runSync(() -> target.kickPlayer(kickMessage));
        }
        if (this.plugin.getWebhookClient() != null) {
            this.plugin.getWebhookClient().sendBanNotification(targetName, issuerName, reason, this.formatDuration(duration));
        }
    }

    public void unban(UUID targetUuid, String targetName, String remover) {
        List<Punishment> bans = this.activeBans.remove(targetUuid);
        if (bans != null) {
            for (Punishment ban : bans) {
                ban.setActive(false);
                ban.setRemoved(true);
                ban.setRemovedBy(remover);
                ban.setRemovedAt(System.currentTimeMillis());
                this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().updatePunishment(ban));
            }
        }
        if (this.plugin.getWebhookClient() != null) {
            this.plugin.getWebhookClient().sendUnbanNotification(targetName, remover);
        }
    }

    public void mute(UUID targetUuid, String targetName, UUID issuerUuid, String issuerName, String reason, long duration) {
        String id = UUID.randomUUID().toString();
        Punishment.PunishmentType type = duration > 0L ? Punishment.PunishmentType.TEMPMUTE : Punishment.PunishmentType.MUTE;
        Punishment punishment = new Punishment(id, targetUuid, targetName, issuerUuid, issuerName, type, reason, duration);
        this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().savePunishment(punishment));
        this.activeMutes.computeIfAbsent(targetUuid, k -> new ArrayList()).add(punishment);
        Player target = Bukkit.getPlayer((UUID)targetUuid);
        if (target != null && target.isOnline()) {
            target.sendMessage("\u00a7cYou have been muted.");
            target.sendMessage("\u00a77Reason: \u00a7f" + reason);
            if (duration > 0L) {
                target.sendMessage("\u00a77Duration: \u00a7f" + this.formatDuration(duration));
            } else {
                target.sendMessage("\u00a77Duration: \u00a7fPermanent");
            }
            target.sendMessage("\u00a77Muted by: \u00a7f" + issuerName);
        }
    }

    public void unmute(UUID targetUuid, String remover) {
        Player target;
        List<Punishment> mutes = this.activeMutes.remove(targetUuid);
        if (mutes != null) {
            for (Punishment mute : mutes) {
                mute.setActive(false);
                mute.setRemoved(true);
                mute.setRemovedBy(remover);
                mute.setRemovedAt(System.currentTimeMillis());
                this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().updatePunishment(mute));
            }
        }
        if ((target = Bukkit.getPlayer((UUID)targetUuid)) != null && target.isOnline()) {
            target.sendMessage("\u00a7aYou have been unmuted by " + remover);
        }
    }

    public void warn(UUID targetUuid, String targetName, UUID issuerUuid, String issuerName, String reason) {
        String id = UUID.randomUUID().toString();
        Punishment punishment = new Punishment(id, targetUuid, targetName, issuerUuid, issuerName, Punishment.PunishmentType.WARN, reason, 0L);
        punishment.setActive(false);
        this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().savePunishment(punishment));
        Player target = Bukkit.getPlayer((UUID)targetUuid);
        if (target != null && target.isOnline()) {
            target.sendMessage("\u00a7c\u00a7lWARNING");
            target.sendMessage("\u00a77You have been warned by \u00a7f" + issuerName);
            target.sendMessage("\u00a77Reason: \u00a7f" + reason);
        }
    }

    public void kick(UUID targetUuid, String targetName, UUID issuerUuid, String issuerName, String reason) {
        String id = UUID.randomUUID().toString();
        Punishment punishment = new Punishment(id, targetUuid, targetName, issuerUuid, issuerName, Punishment.PunishmentType.KICK, reason, 0L);
        punishment.setActive(false);
        this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().savePunishment(punishment));
        Player target = Bukkit.getPlayer((UUID)targetUuid);
        if (target != null && target.isOnline()) {
            String kickMessage = "\u00a7cYou have been kicked.\n\u00a77Reason: \u00a7f" + reason + "\n\u00a77Kicked by: \u00a7f" + issuerName;
            this.plugin.getAsyncUtil().runSync(() -> target.kickPlayer(kickMessage));
        }
    }

    public boolean isBanned(UUID uuid) {
        List<Punishment> bans = this.activeBans.get(uuid);
        if (bans == null || bans.isEmpty()) {
            return false;
        }
        bans.removeIf(ban -> {
            if (ban.isExpired()) {
                ban.setActive(false);
                this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().updatePunishment((Punishment)ban));
                return true;
            }
            return false;
        });
        if (bans.isEmpty()) {
            this.activeBans.remove(uuid);
            return false;
        }
        return true;
    }

    public boolean isMuted(UUID uuid) {
        List<Punishment> mutes = this.activeMutes.get(uuid);
        if (mutes == null || mutes.isEmpty()) {
            return false;
        }
        mutes.removeIf(mute -> {
            if (mute.isExpired()) {
                mute.setActive(false);
                this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().updatePunishment((Punishment)mute));
                return true;
            }
            return false;
        });
        if (mutes.isEmpty()) {
            this.activeMutes.remove(uuid);
            return false;
        }
        return true;
    }

    public Punishment getActiveBan(UUID uuid) {
        List<Punishment> bans = this.activeBans.get(uuid);
        if (bans != null && !bans.isEmpty()) {
            return bans.get(0);
        }
        return null;
    }

    public Punishment getActiveMute(UUID uuid) {
        List<Punishment> mutes = this.activeMutes.get(uuid);
        if (mutes != null && !mutes.isEmpty()) {
            return mutes.get(0);
        }
        return null;
    }

    public List<Punishment> getPunishmentHistory(UUID uuid) {
        List<Punishment> cached = this.punishmentCache.get(uuid);
        if (cached != null) {
            return new ArrayList<Punishment>(cached);
        }
        List<Punishment> history = this.plugin.getStorageProvider().loadPlayerPunishments(uuid);
        history.sort((a, b) -> Long.compare(b.getIssuedAt(), a.getIssuedAt()));
        this.punishmentCache.put(uuid, history);
        return new ArrayList<Punishment>(history);
    }

    public List<Punishment> getAllActiveBans() {
        return this.activeBans.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String formatBanMessage(Punishment ban, String issuer) {
        StringBuilder msg = new StringBuilder();
        msg.append("\u00a7c\u00a7lYou are banned from this server!\n\n");
        msg.append("\u00a77Reason: \u00a7f").append(ban.getReason()).append("\n");
        if (ban.isPermanent()) {
            msg.append("\u00a77Duration: \u00a7fPermanent\n");
        } else {
            long remaining = ban.getExpiresAt() - System.currentTimeMillis();
            msg.append("\u00a77Expires in: \u00a7f").append(this.formatDuration(remaining)).append("\n");
        }
        msg.append("\u00a77Banned by: \u00a7f").append(issuer).append("\n\n");
        msg.append("\u00a77Appeal at: \u00a7f").append(this.plugin.getConfigManager().getConfig().getString("moderation.appeal-url", "N/A"));
        return msg.toString();
    }

    public String formatDuration(long millis) {
        if (millis <= 0L) {
            return "Permanent";
        }
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + " day" + (days > 1L ? "s" : "");
        }
        if (hours > 0L) {
            return hours + " hour" + (hours > 1L ? "s" : "");
        }
        if (minutes > 0L) {
            return minutes + " minute" + (minutes > 1L ? "s" : "");
        }
        return seconds + " second" + (seconds > 1L ? "s" : "");
    }

    public long parseDuration(String input) {
        if (input == null || input.isEmpty() || input.equalsIgnoreCase("permanent") || input.equalsIgnoreCase("perm")) {
            return -1L;
        }
        try {
            String numStr = input.replaceAll("[^0-9]", "");
            String unitStr = input.replaceAll("[0-9]", "").toLowerCase();
            if (numStr.isEmpty()) {
                return -1L;
            }
            long value = Long.parseLong(numStr);
            switch (unitStr) {
                case "s": 
                case "sec": 
                case "second": 
                case "seconds": {
                    return value * 1000L;
                }
                case "m": 
                case "min": 
                case "minute": 
                case "minutes": {
                    return value * 60L * 1000L;
                }
                case "h": 
                case "hr": 
                case "hour": 
                case "hours": {
                    return value * 60L * 60L * 1000L;
                }
                case "d": 
                case "day": 
                case "days": {
                    return value * 24L * 60L * 60L * 1000L;
                }
                case "w": 
                case "week": 
                case "weeks": {
                    return value * 7L * 24L * 60L * 60L * 1000L;
                }
                case "mo": 
                case "month": 
                case "months": {
                    return value * 30L * 24L * 60L * 60L * 1000L;
                }
                case "y": 
                case "year": 
                case "years": {
                    return value * 365L * 24L * 60L * 60L * 1000L;
                }
            }
            return -1L;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public void clearCache(UUID uuid) {
        this.punishmentCache.remove(uuid);
    }
}

