/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.performance;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.performance.PerformanceReport;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadMXBean;
import org.bukkit.plugin.Plugin;

public class PerformanceMonitor {
    private final UnifiedSecureMgr plugin;
    private final MemoryMXBean memoryBean;
    private final ThreadMXBean threadBean;
    private double[] tpsHistory;
    private int tpsIndex;

    public PerformanceMonitor(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.memoryBean = ManagementFactory.getMemoryMXBean();
        this.threadBean = ManagementFactory.getThreadMXBean();
        this.tpsHistory = new double[60];
        this.tpsIndex = 0;
        this.startMonitoring();
    }

    private void startMonitoring() {
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            double tps;
            this.tpsHistory[this.tpsIndex] = tps = this.getCurrentTPS();
            this.tpsIndex = (this.tpsIndex + 1) % this.tpsHistory.length;
        }, 20L, 20L);
    }

    public double getCurrentTPS() {
        try {
            Object server = this.plugin.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)this.plugin.getServer(), new Object[0]);
            double[] recentTps = (double[])server.getClass().getField("recentTps").get(server);
            return Math.min(20.0, recentTps[0]);
        }
        catch (Exception e) {
            return 20.0;
        }
    }

    public double getAverageTPS(int seconds) {
        int count = Math.min(seconds, this.tpsHistory.length);
        double sum = 0.0;
        for (int i = 0; i < count; ++i) {
            sum += this.tpsHistory[i];
        }
        return sum / (double)count;
    }

    public PerformanceReport generateReport() {
        PerformanceReport report = new PerformanceReport();
        report.setCurrentTPS(this.getCurrentTPS());
        report.setAverage1m(this.getAverageTPS(60));
        report.setAverage5m(this.getAverageTPS(300));
        report.setAverage15m(this.getAverageTPS(900));
        long heapUsed = this.memoryBean.getHeapMemoryUsage().getUsed() / 0x100000L;
        long heapMax = this.memoryBean.getHeapMemoryUsage().getMax() / 0x100000L;
        long heapCommitted = this.memoryBean.getHeapMemoryUsage().getCommitted() / 0x100000L;
        report.setHeapUsed(heapUsed);
        report.setHeapMax(heapMax);
        report.setHeapCommitted(heapCommitted);
        report.setHeapPercent((int)((double)heapUsed * 100.0 / (double)heapMax));
        report.setThreadCount(this.threadBean.getThreadCount());
        report.setDaemonThreadCount(this.threadBean.getDaemonThreadCount());
        report.setPeakThreadCount(this.threadBean.getPeakThreadCount());
        report.setOnlinePlayers(this.plugin.getServer().getOnlinePlayers().size());
        report.setMaxPlayers(this.plugin.getServer().getMaxPlayers());
        report.setWorldCount(this.plugin.getServer().getWorlds().size());
        report.setUptime(this.plugin.getUptime());
        return report;
    }

    public String getTPSColor(double tps) {
        if (tps >= 19.0) {
            return "\u00a7a";
        }
        if (tps >= 17.0) {
            return "\u00a7e";
        }
        if (tps >= 15.0) {
            return "\u00a76";
        }
        return "\u00a7c";
    }

    public String getMemoryColor(int percent) {
        if (percent < 60) {
            return "\u00a7a";
        }
        if (percent < 80) {
            return "\u00a7e";
        }
        if (percent < 90) {
            return "\u00a76";
        }
        return "\u00a7c";
    }
}

