/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.player;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.model.PlaytimeData;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class PlaytimeTracker {
    private final UnifiedSecureMgr plugin;
    private final Map<UUID, PlaytimeData> playtimeCache;

    public PlaytimeTracker(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.playtimeCache = new ConcurrentHashMap<UUID, PlaytimeData>();
        this.loadAllData();
    }

    private void loadAllData() {
        this.plugin.getAsyncUtil().runAsync(() -> {
            List<PlaytimeData> allData = this.plugin.getStorageProvider().loadAllPlaytimeData();
            allData.forEach(data -> this.playtimeCache.put(data.getUuid(), (PlaytimeData)data));
            this.plugin.getLogger().info("Loaded " + allData.size() + " playtime records.");
        });
    }

    public void startSession(Player player) {
        UUID uuid = player.getUniqueId();
        PlaytimeData data = this.playtimeCache.computeIfAbsent(uuid, k -> new PlaytimeData(uuid, player.getName()));
        data.setUsername(player.getName());
        data.setSessionStart(System.currentTimeMillis());
        data.setLastActivity(System.currentTimeMillis());
        data.setOnline(true);
        this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().savePlaytimeData(data));
    }

    public void endSession(Player player) {
        UUID uuid = player.getUniqueId();
        PlaytimeData data = this.playtimeCache.get(uuid);
        if (data != null && data.isOnline()) {
            long sessionTime = System.currentTimeMillis() - data.getSessionStart();
            data.addPlaytime(sessionTime);
            data.setOnline(false);
            this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().savePlaytimeData(data));
        }
    }

    public void updateActivity(Player player) {
        UUID uuid = player.getUniqueId();
        PlaytimeData data = this.playtimeCache.get(uuid);
        if (data != null && data.isOnline()) {
            data.setLastActivity(System.currentTimeMillis());
        }
    }

    public long getTotalPlaytime(UUID uuid) {
        PlaytimeData data = this.getPlaytimeData(uuid);
        return data != null ? data.getTotalPlaytime() : 0L;
    }

    public PlaytimeData getPlaytimeData(UUID uuid) {
        PlaytimeData data = this.playtimeCache.get(uuid);
        if (data != null && data.isOnline()) {
            long currentSession = System.currentTimeMillis() - data.getSessionStart();
            PlaytimeData copy = new PlaytimeData(data.getUuid(), data.getUsername());
            copy.setTotalPlaytime(data.getTotalPlaytime() + currentSession);
            copy.setSessionStart(data.getSessionStart());
            copy.setLastActivity(data.getLastActivity());
            copy.setOnline(data.isOnline());
            return copy;
        }
        return data;
    }

    public PlaytimeData getPlaytimeData(String username) {
        return this.playtimeCache.values().stream().filter(data -> data.getUsername().equalsIgnoreCase(username)).findFirst().orElse(null);
    }

    public List<PlaytimeData> getTopPlaytime(int limit) {
        return this.playtimeCache.values().stream().sorted((a, b) -> Long.compare(b.getTotalPlaytime(), a.getTotalPlaytime())).limit(limit).toList();
    }

    public void deletePlayerData(UUID uuid) {
        this.playtimeCache.remove(uuid);
        this.plugin.getAsyncUtil().runAsync(() -> this.plugin.getStorageProvider().deletePlaytimeData(uuid));
    }

    public void saveAll() {
        this.plugin.getAsyncUtil().runAsync(() -> this.playtimeCache.values().forEach(data -> {
            if (data.isOnline()) {
                long currentSession = System.currentTimeMillis() - data.getSessionStart();
                PlaytimeData saveData = new PlaytimeData(data.getUuid(), data.getUsername());
                saveData.setTotalPlaytime(data.getTotalPlaytime() + currentSession);
                saveData.setSessionStart(data.getSessionStart());
                saveData.setLastActivity(data.getLastActivity());
                saveData.setOnline(data.isOnline());
                this.plugin.getStorageProvider().savePlaytimeData(saveData);
            } else {
                this.plugin.getStorageProvider().savePlaytimeData((PlaytimeData)data);
            }
        }));
    }

    public String formatPlaytime(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return String.format("%dd %dh %dm", days, hours % 24L, minutes % 60L);
        }
        if (hours > 0L) {
            return String.format("%dh %dm", hours, minutes % 60L);
        }
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, seconds % 60L);
        }
        return String.format("%ds", seconds);
    }
}

