/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.risk;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.cluster.AccountCluster;
import com.unifiedsecure.model.Punishment;
import com.unifiedsecure.risk.RiskLevel;
import com.unifiedsecure.risk.RiskProfile;
import com.unifiedsecure.vpn.VPNCheckResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RiskAlertSystem {
    private final UnifiedSecureMgr plugin;
    private final Map<UUID, RiskProfile> profiles;

    public RiskAlertSystem(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.profiles = new ConcurrentHashMap<UUID, RiskProfile>();
    }

    public void analyzePlayer(Player player) {
        this.plugin.getAsyncUtil().runAsync(() -> {
            RiskProfile profile = this.createProfile(player);
            this.profiles.put(player.getUniqueId(), profile);
            if (profile.getRiskLevel().ordinal() >= RiskLevel.MEDIUM.ordinal()) {
                this.plugin.getAsyncUtil().runSync(() -> this.alertStaff(player, profile));
            }
            if (this.plugin.getLoggerService() != null) {
                this.plugin.getLoggerService().logSecurity("RISK_ANALYSIS", player.getName() + " risk level: " + String.valueOf((Object)profile.getRiskLevel()) + " (score: " + profile.getRiskScore() + ")");
            }
        });
    }

    private RiskProfile createProfile(Player player) {
        List<Punishment> punishments;
        int trustScore;
        long oneDayMs;
        long accountAge;
        List<AccountCluster> clusters;
        int altCount;
        RiskProfile profile = new RiskProfile(player.getUniqueId());
        int score = 0;
        ArrayList<String> flags = new ArrayList<String>();
        String ip = player.getAddress().getAddress().getHostAddress();
        if (this.plugin.getVPNDetector() != null) {
            VPNCheckResult vpnCheck = this.plugin.getVPNDetector().check(ip);
            if (vpnCheck.isVPN()) {
                score += 30;
                flags.add("VPN_DETECTED");
            }
            if (vpnCheck.isProxy()) {
                score += 25;
                flags.add("PROXY_DETECTED");
            }
            if (vpnCheck.isTor()) {
                score += 40;
                flags.add("TOR_DETECTED");
            }
        }
        if (this.plugin.getAltDetector() != null && (altCount = this.plugin.getAltDetector().getAltCount(player.getUniqueId())) > 3) {
            score += 20;
            flags.add("MULTIPLE_ALTS");
        }
        if (this.plugin.getClusterDetector() != null && !(clusters = this.plugin.getClusterDetector().getPlayerClusters(player.getUniqueId())).isEmpty()) {
            score += clusters.size() * 10;
            flags.add("ACCOUNT_CLUSTER");
        }
        if ((accountAge = System.currentTimeMillis() - player.getFirstPlayed()) < (oneDayMs = 86400000L)) {
            score += 15;
            flags.add("NEW_ACCOUNT");
        }
        if (this.plugin.getTrustSystem() != null && (trustScore = this.plugin.getTrustSystem().getTrustScore(player.getUniqueId())) < 30) {
            score += 20;
            flags.add("LOW_TRUST");
        }
        if (this.plugin.getStorageProvider() != null && !(punishments = this.plugin.getStorageProvider().loadPlayerPunishments(player.getUniqueId())).isEmpty()) {
            score += punishments.size() * 5;
            flags.add("PUNISHMENT_HISTORY");
        }
        if (this.plugin.getGeoIPService() != null) {
            this.plugin.getGeoIPService().lookupAsync(ip, result -> {
                if (result != null) {
                    String country = result.getCountry();
                    List highRiskCountries = this.plugin.getConfigManager().getConfig().getStringList("risk.highRiskCountries");
                    if (highRiskCountries.contains(country)) {
                        profile.addFlag("HIGH_RISK_COUNTRY");
                        profile.addRiskScore(10);
                    }
                }
            });
        }
        profile.setRiskScore(score);
        profile.setFlags(flags);
        profile.setRiskLevel(this.calculateRiskLevel(score));
        return profile;
    }

    private RiskLevel calculateRiskLevel(int score) {
        if (score >= 80) {
            return RiskLevel.CRITICAL;
        }
        if (score >= 60) {
            return RiskLevel.HIGH;
        }
        if (score >= 40) {
            return RiskLevel.MEDIUM;
        }
        if (score >= 20) {
            return RiskLevel.LOW;
        }
        return RiskLevel.NONE;
    }

    private void alertStaff(Player player, RiskProfile profile) {
        String message = "\u00a7c[Risk Alert] \u00a7e" + player.getName() + " \u00a77- " + profile.getRiskLevel().getDisplay() + " \u00a77(Score: " + profile.getRiskScore() + ")";
        if (!profile.getFlags().isEmpty()) {
            message = message + "\n\u00a77Flags: \u00a7f" + String.join((CharSequence)", ", profile.getFlags());
        }
        String finalMessage = message;
        this.plugin.getServer().getOnlinePlayers().stream().filter(p -> p.hasPermission("unified.risk.alerts")).forEach(p -> p.sendMessage(finalMessage));
        if (profile.getRiskLevel() == RiskLevel.CRITICAL && this.plugin.getConfigManager().getConfig().getBoolean("risk.autoKickCritical", false)) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.kickPlayer("\u00a7cSecurity check failed. Please contact an administrator."));
        }
    }

    public RiskProfile getProfile(UUID uuid) {
        return this.profiles.get(uuid);
    }

    public Map<UUID, RiskProfile> getAllProfiles() {
        return new ConcurrentHashMap<UUID, RiskProfile>(this.profiles);
    }
}

