/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.snapshot;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.model.Punishment;
import com.unifiedsecure.snapshot.PlayerSnapshot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SnapshotSystem {
    private final UnifiedSecureMgr plugin;
    private final Map<UUID, List<PlayerSnapshot>> snapshots;

    public SnapshotSystem(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.snapshots = new ConcurrentHashMap<UUID, List<PlayerSnapshot>>();
    }

    public PlayerSnapshot createSnapshot(Player player) {
        PlayerSnapshot snapshot = new PlayerSnapshot();
        snapshot.setUuid(player.getUniqueId());
        snapshot.setName(player.getName());
        snapshot.setTimestamp(System.currentTimeMillis());
        if (this.plugin.getIPTracker() != null) {
            String ip = player.getAddress().getAddress().getHostAddress();
            snapshot.setCurrentIp(ip);
            snapshot.setIpHistory(new ArrayList<String>(this.plugin.getIPTracker().getPlayerData(player.getUniqueId()).getIpHistory()));
        }
        Location loc = player.getLocation();
        snapshot.setLocation(loc.getWorld().getName() + " " + (int)loc.getX() + " " + (int)loc.getY() + " " + (int)loc.getZ());
        snapshot.setGameMode(player.getGameMode().name());
        snapshot.setHealth(player.getHealth());
        snapshot.setFoodLevel(player.getFoodLevel());
        snapshot.setLevel(player.getLevel());
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        inventory.addAll(Arrays.asList(player.getInventory().getContents()));
        inventory.addAll(Arrays.asList(player.getInventory().getArmorContents()));
        snapshot.setInventory(inventory);
        if (this.plugin.getStorageProvider() != null) {
            List<Punishment> punishments = this.plugin.getStorageProvider().loadPlayerPunishments(player.getUniqueId());
            snapshot.setPunishmentHistory(punishments);
        }
        if (this.plugin.getPlaytimeTracker() != null) {
            snapshot.setPlaytime(this.plugin.getPlaytimeTracker().getTotalPlaytime(player.getUniqueId()));
        }
        if (this.plugin.getTrustSystem() != null) {
            snapshot.setTrustScore(this.plugin.getTrustSystem().getTrustScore(player.getUniqueId()));
        }
        this.snapshots.computeIfAbsent(player.getUniqueId(), k -> new ArrayList()).add(snapshot);
        if (this.plugin.getLoggerService() != null) {
            this.plugin.getLoggerService().logSecurity("SNAPSHOT_CREATED", "Snapshot created for " + player.getName());
        }
        return snapshot;
    }

    public List<PlayerSnapshot> getSnapshots(UUID uuid) {
        return this.snapshots.getOrDefault(uuid, Collections.emptyList());
    }

    public PlayerSnapshot getLatestSnapshot(UUID uuid) {
        List<PlayerSnapshot> list = this.snapshots.get(uuid);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public void deleteSnapshots(UUID uuid) {
        this.snapshots.remove(uuid);
    }

    public int getTotalSnapshots() {
        return this.snapshots.values().stream().mapToInt(List::size).sum();
    }
}

