/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.staff;

import com.unifiedsecure.UnifiedSecureMgr;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FreezeManager {
    private final UnifiedSecureMgr plugin;
    private final Set<UUID> frozen;

    public FreezeManager(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.frozen = new HashSet<UUID>();
    }

    public void freeze(Player player, Player staff) {
        this.frozen.add(player.getUniqueId());
        player.sendMessage("\u00a7c\u00a7l[!] You have been frozen by staff!");
        player.sendMessage("\u00a7c\u00a7lDo not log out or you will be banned!");
        player.sendMessage("\u00a7e\u00a7lPlease wait for staff assistance.");
        staff.sendMessage("\u00a7aFroze " + player.getName());
        if (this.plugin.getLoggerService() != null) {
            this.plugin.getLoggerService().logStaff(staff.getUniqueId(), "FREEZE", player.getName());
        }
    }

    public void unfreeze(Player player, Player staff) {
        this.frozen.remove(player.getUniqueId());
        player.sendMessage("\u00a7aYou have been unfrozen. You may continue playing.");
        staff.sendMessage("\u00a7aUnfroze " + player.getName());
        if (this.plugin.getLoggerService() != null) {
            this.plugin.getLoggerService().logStaff(staff.getUniqueId(), "UNFREEZE", player.getName());
        }
    }

    public void toggle(Player player, Player staff) {
        if (this.isFrozen(player)) {
            this.unfreeze(player, staff);
        } else {
            this.freeze(player, staff);
        }
    }

    public boolean isFrozen(Player player) {
        return this.frozen.contains(player.getUniqueId());
    }

    public boolean isFrozen(UUID uuid) {
        return this.frozen.contains(uuid);
    }

    public Set<UUID> getFrozen() {
        return new HashSet<UUID>(this.frozen);
    }

    public void handleQuit(UUID uuid) {
        if (this.frozen.contains(uuid)) {
            this.frozen.remove(uuid);
            if (this.plugin.getConfigManager().getConfig().getBoolean("freeze.banOnLogout", true)) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "ban " + this.plugin.getServer().getOfflinePlayer(uuid).getName() + " Logged out while frozen");
            }
        }
    }
}

