/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.staff;

import com.unifiedsecure.UnifiedSecureMgr;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class StaffModeListener
implements Listener {
    private final UnifiedSecureMgr plugin;
    private final Random random;

    public StaffModeListener(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.random = new Random();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getStaffModeManager().isInStaffMode(player)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        String displayName = item.getItemMeta().getDisplayName();
        if (displayName.contains("Vanish Toggle")) {
            event.setCancelled(true);
            if (this.plugin.getVanishManager() != null) {
                this.plugin.getVanishManager().toggle(player);
            }
        } else if (displayName.contains("Random Teleport")) {
            event.setCancelled(true);
            this.teleportToRandomPlayer(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getStaffModeManager().isInStaffMode(player)) {
            return;
        }
        if (!(event.getRightClicked() instanceof Player)) {
            return;
        }
        Player target = (Player)event.getRightClicked();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        String displayName = item.getItemMeta().getDisplayName();
        event.setCancelled(true);
        if (displayName.contains("Inspect Tool")) {
            this.showPlayerInfo(player, target);
        } else if (displayName.contains("Inventory Inspector")) {
            player.openInventory((Inventory)target.getInventory());
            player.sendMessage("\u00a7aOpened inventory of \u00a7f" + target.getName());
        } else if (displayName.contains("Freeze Player")) {
            if (this.plugin.getFreezeManager() != null) {
                this.plugin.getFreezeManager().toggle(target, player);
            }
        } else if (displayName.contains("Snapshot Tool") && this.plugin.getSnapshotSystem() != null) {
            this.plugin.getSnapshotSystem().createSnapshot(target);
            player.sendMessage("\u00a7aCreated snapshot for \u00a7f" + target.getName());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.plugin.getStaffModeManager().isInStaffMode(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.plugin.getStaffModeManager().isInStaffMode(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onItemDrop(PlayerDropItemEvent event) {
        if (this.plugin.getStaffModeManager().isInStaffMode(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onItemPickup(PlayerPickupItemEvent event) {
        if (this.plugin.getStaffModeManager().isInStaffMode(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player) {
            Player player = (Player)event.getWhoClicked();
            if (this.plugin.getStaffModeManager().isInStaffMode(player) && event.getClickedInventory() == player.getInventory()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (this.plugin.getStaffModeManager().isInStaffMode(player)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player) {
            Player damager = (Player)event.getDamager();
            if (this.plugin.getStaffModeManager().isInStaffMode(damager)) {
                event.setCancelled(true);
            }
        }
    }

    private void showPlayerInfo(Player staff, Player target) {
        staff.sendMessage("\u00a76\u00a7l=== Player Info: " + target.getName() + " ===");
        staff.sendMessage("\u00a77UUID: \u00a7f" + String.valueOf(target.getUniqueId()));
        staff.sendMessage("\u00a77Health: \u00a7f" + target.getHealth() + "/" + target.getMaxHealth());
        staff.sendMessage("\u00a77Food: \u00a7f" + target.getFoodLevel() + "/20");
        staff.sendMessage("\u00a77GameMode: \u00a7f" + String.valueOf(target.getGameMode()));
        staff.sendMessage("\u00a77Flying: \u00a7f" + (target.isFlying() ? "Yes" : "No"));
        staff.sendMessage("\u00a77Location: \u00a7f" + target.getLocation().getBlockX() + ", " + target.getLocation().getBlockY() + ", " + target.getLocation().getBlockZ());
        staff.sendMessage("\u00a77Ping: \u00a7f" + this.getPing(target) + "ms");
        if (this.plugin.getFreezeManager() != null && this.plugin.getFreezeManager().isFrozen(target)) {
            staff.sendMessage("\u00a7c\u00a7lFROZEN");
        }
        if (this.plugin.getVanishManager() != null && this.plugin.getVanishManager().isVanished(target)) {
            staff.sendMessage("\u00a77Vanished: \u00a7aYes");
        }
    }

    private int getPing(Player player) {
        try {
            Object handle = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            return (Integer)handle.getClass().getField("ping").get(handle);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private void teleportToRandomPlayer(Player staff) {
        ArrayList<Player> onlinePlayers = new ArrayList<Player>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.equals((Object)staff) || this.plugin.getStaffModeManager().isInStaffMode(p) || this.plugin.getVanishManager() != null && this.plugin.getVanishManager().isVanished(p)) continue;
            onlinePlayers.add(p);
        }
        if (onlinePlayers.isEmpty()) {
            staff.sendMessage("\u00a7cNo players available to teleport to!");
            return;
        }
        Player target = (Player)onlinePlayers.get(this.random.nextInt(onlinePlayers.size()));
        staff.teleport(target.getLocation());
        staff.sendMessage("\u00a7aTeleported to \u00a7f" + target.getName());
    }
}

