/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.staff;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.staff.StaffModeData;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class StaffModeManager {
    private final UnifiedSecureMgr plugin;
    private final Map<UUID, StaffModeData> staffMode;

    public StaffModeManager(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.staffMode = new HashMap<UUID, StaffModeData>();
    }

    public void enable(Player player) {
        if (this.isInStaffMode(player)) {
            player.sendMessage("\u00a7cYou are already in staff mode!");
            return;
        }
        StaffModeData data = new StaffModeData();
        data.setInventory(player.getInventory().getContents());
        data.setArmor(player.getInventory().getArmorContents());
        data.setGameMode(player.getGameMode());
        data.setAllowFlight(player.getAllowFlight());
        data.setFlying(player.isFlying());
        this.staffMode.put(player.getUniqueId(), data);
        player.getInventory().clear();
        player.setGameMode(GameMode.CREATIVE);
        player.setAllowFlight(true);
        player.setFlying(true);
        this.giveStaffItems(player);
        if (this.plugin.getVanishManager() != null) {
            this.plugin.getVanishManager().vanish(player);
        }
        player.sendMessage("\u00a7aStaff mode enabled");
        if (this.plugin.getLoggerService() != null) {
            this.plugin.getLoggerService().logStaff(player.getUniqueId(), "STAFF_MODE_ENABLE", "");
        }
    }

    public void disable(Player player) {
        StaffModeData data = this.staffMode.remove(player.getUniqueId());
        if (data == null) {
            player.sendMessage("\u00a7cYou are not in staff mode!");
            return;
        }
        player.getInventory().clear();
        player.getInventory().setContents(data.getInventory());
        player.getInventory().setArmorContents(data.getArmor());
        player.setGameMode(data.getGameMode());
        player.setAllowFlight(data.isAllowFlight());
        player.setFlying(data.isFlying());
        if (this.plugin.getVanishManager() != null && this.plugin.getVanishManager().isVanished(player)) {
            this.plugin.getVanishManager().unvanish(player);
        }
        player.sendMessage("\u00a7cStaff mode disabled");
        if (this.plugin.getLoggerService() != null) {
            this.plugin.getLoggerService().logStaff(player.getUniqueId(), "STAFF_MODE_DISABLE", "");
        }
    }

    public void toggle(Player player) {
        if (this.isInStaffMode(player)) {
            this.disable(player);
        } else {
            this.enable(player);
        }
    }

    private void giveStaffItems(Player player) {
        player.getInventory().setItem(0, this.createItem(Material.COMPASS, "\u00a7aInspect Tool", "\u00a77Right-click a player to inspect"));
        player.getInventory().setItem(1, this.createItem(Material.BOOK, "\u00a7ePlayer List", "\u00a77View all online players"));
        player.getInventory().setItem(2, this.createItem(Material.CHEST, "\u00a76Inventory Inspector", "\u00a77Right-click to view inventories"));
        player.getInventory().setItem(3, this.createItem(Material.ICE, "\u00a7bFreeze Player", "\u00a77Right-click to freeze/unfreeze"));
        player.getInventory().setItem(4, this.createItem(Material.PAPER, "\u00a7dSnapshot Tool", "\u00a77Right-click to create snapshot"));
        player.getInventory().setItem(7, this.createItem(Material.ENDER_PEARL, "\u00a75Random Teleport", "\u00a77Teleport to random player"));
        player.getInventory().setItem(8, this.createItem(Material.REDSTONE, "\u00a7cVanish Toggle", "\u00a77Toggle vanish mode"));
    }

    private ItemStack createItem(Material material, String name, String lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(Collections.singletonList(lore));
        item.setItemMeta(meta);
        return item;
    }

    public boolean isInStaffMode(Player player) {
        return this.staffMode.containsKey(player.getUniqueId());
    }

    public Set<UUID> getStaffModeUsers() {
        return new HashSet<UUID>(this.staffMode.keySet());
    }
}

