/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.coreprotect.BlockLogEntry;
import com.unifiedsecure.model.AltDetection;
import com.unifiedsecure.model.IPBan;
import com.unifiedsecure.model.LogEntry;
import com.unifiedsecure.model.PlayerIPData;
import com.unifiedsecure.model.PlaytimeData;
import com.unifiedsecure.model.Punishment;
import com.unifiedsecure.storage.StorageProvider;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;

public class LocalJsonStorage
implements StorageProvider {
    private final UnifiedSecureMgr plugin;
    private final Gson gson;
    private File dataFolder;
    private Map<UUID, PlayerIPData> playerIPDataMap;
    private Map<String, IPBan> ipBanMap;
    private List<AltDetection> altDetections;
    private Map<UUID, PlaytimeData> playtimeDataMap;
    private Map<String, Punishment> punishmentMap;
    private List<LogEntry> logEntries;
    private List<BlockLogEntry> blockLogEntries;

    public LocalJsonStorage(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    @Override
    public void initialize() throws Exception {
        this.dataFolder = new File(this.plugin.getDataFolder(), "data");
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        this.playerIPDataMap = new HashMap<UUID, PlayerIPData>();
        this.ipBanMap = new HashMap<String, IPBan>();
        this.altDetections = new ArrayList<AltDetection>();
        this.playtimeDataMap = new HashMap<UUID, PlaytimeData>();
        this.punishmentMap = new HashMap<String, Punishment>();
        this.logEntries = new ArrayList<LogEntry>();
        this.blockLogEntries = new ArrayList<BlockLogEntry>();
        this.loadAllData();
        this.plugin.getLogger().info("Local JSON storage initialized successfully.");
    }

    @Override
    public void close() {
        this.saveAllData();
    }

    private void loadAllData() {
        this.loadPlayerIPData();
        this.loadIPBans();
        this.loadAltDetections();
        this.loadPlaytimeData();
        this.loadPunishments();
        this.loadLogEntries();
        this.loadBlockLogs();
    }

    private void saveAllData() {
        this.savePlayerIPDataToFile();
        this.saveIPBansToFile();
        this.saveAltDetectionsToFile();
        this.savePlaytimeDataToFile();
        this.savePunishmentsToFile();
        this.saveLogEntriesToFile();
        this.saveBlockLogsToFile();
    }

    private void loadPlayerIPData() {
        File file = new File(this.dataFolder, "player_ip_data.json");
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Type type = new TypeToken<Map<UUID, PlayerIPData>>(this){}.getType();
                Map loaded = (Map)this.gson.fromJson((Reader)reader, type);
                if (loaded != null) {
                    this.playerIPDataMap = loaded;
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to load player IP data: " + e.getMessage());
            }
        }
    }

    private void savePlayerIPDataToFile() {
        File file = new File(this.dataFolder, "player_ip_data.json");
        try (FileWriter writer = new FileWriter(file);){
            this.gson.toJson(this.playerIPDataMap, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save player IP data: " + e.getMessage());
        }
    }

    private void loadIPBans() {
        File file = new File(this.dataFolder, "ip_bans.json");
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Type type = new TypeToken<Map<String, IPBan>>(this){}.getType();
                Map loaded = (Map)this.gson.fromJson((Reader)reader, type);
                if (loaded != null) {
                    this.ipBanMap = loaded;
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to load IP bans: " + e.getMessage());
            }
        }
    }

    private void saveIPBansToFile() {
        File file = new File(this.dataFolder, "ip_bans.json");
        try (FileWriter writer = new FileWriter(file);){
            this.gson.toJson(this.ipBanMap, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save IP bans: " + e.getMessage());
        }
    }

    private void loadAltDetections() {
        File file = new File(this.dataFolder, "alt_detections.json");
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Type type = new TypeToken<List<AltDetection>>(this){}.getType();
                List loaded = (List)this.gson.fromJson((Reader)reader, type);
                if (loaded != null) {
                    this.altDetections = loaded;
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to load alt detections: " + e.getMessage());
            }
        }
    }

    private void saveAltDetectionsToFile() {
        File file = new File(this.dataFolder, "alt_detections.json");
        try (FileWriter writer = new FileWriter(file);){
            this.gson.toJson(this.altDetections, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save alt detections: " + e.getMessage());
        }
    }

    private void loadPlaytimeData() {
        File file = new File(this.dataFolder, "playtime_data.json");
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Type type = new TypeToken<Map<UUID, PlaytimeData>>(this){}.getType();
                Map loaded = (Map)this.gson.fromJson((Reader)reader, type);
                if (loaded != null) {
                    this.playtimeDataMap = loaded;
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to load playtime data: " + e.getMessage());
            }
        }
    }

    private void savePlaytimeDataToFile() {
        File file = new File(this.dataFolder, "playtime_data.json");
        try (FileWriter writer = new FileWriter(file);){
            this.gson.toJson(this.playtimeDataMap, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save playtime data: " + e.getMessage());
        }
    }

    private void loadPunishments() {
        File file = new File(this.dataFolder, "punishments.json");
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Type type = new TypeToken<Map<String, Punishment>>(this){}.getType();
                Map loaded = (Map)this.gson.fromJson((Reader)reader, type);
                if (loaded != null) {
                    this.punishmentMap = loaded;
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to load punishments: " + e.getMessage());
            }
        }
    }

    private void savePunishmentsToFile() {
        File file = new File(this.dataFolder, "punishments.json");
        try (FileWriter writer = new FileWriter(file);){
            this.gson.toJson(this.punishmentMap, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save punishments: " + e.getMessage());
        }
    }

    private void loadLogEntries() {
        File file = new File(this.dataFolder, "log_entries.json");
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Type type = new TypeToken<List<LogEntry>>(this){}.getType();
                List loaded = (List)this.gson.fromJson((Reader)reader, type);
                if (loaded != null) {
                    this.logEntries = loaded;
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to load log entries: " + e.getMessage());
            }
        }
    }

    private void saveLogEntriesToFile() {
        File file = new File(this.dataFolder, "log_entries.json");
        try (FileWriter writer = new FileWriter(file);){
            this.gson.toJson(this.logEntries, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save log entries: " + e.getMessage());
        }
    }

    private void loadBlockLogs() {
        File file = new File(this.dataFolder, "block_logs.json");
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Type type = new TypeToken<List<BlockLogEntry>>(this){}.getType();
                List loaded = (List)this.gson.fromJson((Reader)reader, type);
                if (loaded != null) {
                    this.blockLogEntries = loaded;
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to load block logs: " + e.getMessage());
            }
        }
    }

    private void saveBlockLogsToFile() {
        File file = new File(this.dataFolder, "block_logs.json");
        try (FileWriter writer = new FileWriter(file);){
            this.gson.toJson(this.blockLogEntries, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save block logs: " + e.getMessage());
        }
    }

    @Override
    public void savePlayerIPData(PlayerIPData data) {
        this.playerIPDataMap.put(data.getUuid(), data);
        this.savePlayerIPDataToFile();
    }

    @Override
    public PlayerIPData loadPlayerIPData(UUID uuid) {
        return this.playerIPDataMap.get(uuid);
    }

    @Override
    public List<PlayerIPData> loadAllPlayerIPData() {
        return new ArrayList<PlayerIPData>(this.playerIPDataMap.values());
    }

    @Override
    public void deletePlayerIPData(UUID uuid) {
        this.playerIPDataMap.remove(uuid);
        this.savePlayerIPDataToFile();
    }

    @Override
    public void saveIPBan(IPBan ban) {
        this.ipBanMap.put(ban.getIp(), ban);
        this.saveIPBansToFile();
    }

    @Override
    public void removeIPBan(String ip) {
        this.ipBanMap.remove(ip);
        this.saveIPBansToFile();
    }

    @Override
    public IPBan loadIPBan(String ip) {
        return this.ipBanMap.get(ip);
    }

    @Override
    public List<IPBan> loadAllIPBans() {
        return new ArrayList<IPBan>(this.ipBanMap.values());
    }

    @Override
    public void saveAltDetection(AltDetection detection) {
        this.altDetections.add(detection);
        this.saveAltDetectionsToFile();
    }

    @Override
    public List<AltDetection> loadAltDetections(UUID uuid) {
        ArrayList<AltDetection> result = new ArrayList<AltDetection>();
        for (AltDetection detection : this.altDetections) {
            if (!detection.getPlayerUuid().equals(uuid)) continue;
            result.add(detection);
        }
        return result;
    }

    @Override
    public List<AltDetection> loadAllAltDetections() {
        return new ArrayList<AltDetection>(this.altDetections);
    }

    @Override
    public void savePlaytimeData(PlaytimeData data) {
        this.playtimeDataMap.put(data.getUuid(), data);
        this.savePlaytimeDataToFile();
    }

    @Override
    public PlaytimeData loadPlaytimeData(UUID uuid) {
        return this.playtimeDataMap.get(uuid);
    }

    @Override
    public List<PlaytimeData> loadAllPlaytimeData() {
        return new ArrayList<PlaytimeData>(this.playtimeDataMap.values());
    }

    @Override
    public void deletePlaytimeData(UUID uuid) {
        this.playtimeDataMap.remove(uuid);
        this.savePlaytimeDataToFile();
    }

    @Override
    public void savePunishment(Punishment punishment) {
        this.punishmentMap.put(punishment.getId(), punishment);
        this.savePunishmentsToFile();
    }

    @Override
    public void updatePunishment(Punishment punishment) {
        this.savePunishment(punishment);
    }

    @Override
    public Punishment loadPunishment(String punishmentId) {
        return this.punishmentMap.get(punishmentId);
    }

    @Override
    public List<Punishment> loadPlayerPunishments(UUID uuid) {
        ArrayList<Punishment> result = new ArrayList<Punishment>();
        for (Punishment punishment : this.punishmentMap.values()) {
            if (!punishment.getTargetUUID().equals(uuid)) continue;
            result.add(punishment);
        }
        return result;
    }

    @Override
    public List<Punishment> loadActivePunishments() {
        ArrayList<Punishment> result = new ArrayList<Punishment>();
        for (Punishment punishment : this.punishmentMap.values()) {
            if (!punishment.isActive()) continue;
            result.add(punishment);
        }
        return result;
    }

    @Override
    public void saveLogEntry(LogEntry entry) {
        this.logEntries.add(entry);
        if (this.logEntries.size() > 10000) {
            this.logEntries = this.logEntries.subList(this.logEntries.size() - 10000, this.logEntries.size());
        }
        this.saveLogEntriesToFile();
    }

    @Override
    public List<LogEntry> loadLogEntries(long startTime, long endTime) {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        for (LogEntry entry : this.logEntries) {
            if (entry.getTimestamp() < startTime || entry.getTimestamp() > endTime) continue;
            result.add(entry);
        }
        return result;
    }

    @Override
    public List<LogEntry> loadPlayerLogs(UUID uuid, int limit) {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        for (LogEntry entry : this.logEntries) {
            if (entry.getPlayerUuid() == null || !entry.getPlayerUuid().equals(uuid)) continue;
            result.add(entry);
        }
        result.sort((a, b) -> Long.compare(b.getTimestamp(), a.getTimestamp()));
        return result.subList(0, Math.min(limit, result.size()));
    }

    @Override
    public void saveBlockLog(BlockLogEntry entry) {
        this.blockLogEntries.add(entry);
        if (this.blockLogEntries.size() > 50000) {
            this.blockLogEntries = this.blockLogEntries.subList(this.blockLogEntries.size() - 50000, this.blockLogEntries.size());
        }
        this.saveBlockLogsToFile();
    }

    @Override
    public List<BlockLogEntry> lookupBlockLogs(Location location, int radius, long startTime) {
        ArrayList<BlockLogEntry> result = new ArrayList<BlockLogEntry>();
        String world = location.getWorld().getName();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        for (BlockLogEntry entry : this.blockLogEntries) {
            if (!entry.getWorld().equals(world) || entry.getX() < x - radius || entry.getX() > x + radius || entry.getY() < y - radius || entry.getY() > y + radius || entry.getZ() < z - radius || entry.getZ() > z + radius || entry.getTimestamp() < startTime) continue;
            result.add(entry);
        }
        return result;
    }

    @Override
    public List<BlockLogEntry> lookupPlayerBlockLogs(UUID playerId, long startTime) {
        ArrayList<BlockLogEntry> result = new ArrayList<BlockLogEntry>();
        for (BlockLogEntry entry : this.blockLogEntries) {
            if (!entry.getPlayerUuid().equals(playerId) || entry.getTimestamp() < startTime) continue;
            result.add(entry);
        }
        result.sort((a, b) -> Long.compare(b.getTimestamp(), a.getTimestamp()));
        return result;
    }
}

