/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.storage;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.coreprotect.BlockAction;
import com.unifiedsecure.coreprotect.BlockLogEntry;
import com.unifiedsecure.model.AltDetection;
import com.unifiedsecure.model.IPBan;
import com.unifiedsecure.model.LogEntry;
import com.unifiedsecure.model.PlayerIPData;
import com.unifiedsecure.model.PlaytimeData;
import com.unifiedsecure.model.Punishment;
import com.unifiedsecure.storage.StorageProvider;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;

public class SQLiteStorage
implements StorageProvider {
    private final UnifiedSecureMgr plugin;
    private Connection connection;

    public SQLiteStorage(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
    }

    @Override
    public void initialize() throws Exception {
        File dbFile = new File(this.plugin.getDataFolder(), this.plugin.getConfigManager().getSQLiteFileName());
        String url = "jdbc:sqlite:" + dbFile.getAbsolutePath();
        this.connection = DriverManager.getConnection(url);
        this.createTables();
        this.plugin.getLogger().info("SQLite storage initialized successfully.");
    }

    @Override
    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error closing SQLite connection: " + e.getMessage());
        }
    }

    private void createTables() throws SQLException {
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute("CREATE TABLE IF NOT EXISTS player_ip_data (uuid TEXT PRIMARY KEY,username TEXT,current_ip TEXT,ip_history TEXT,first_join BIGINT,last_join BIGINT)");
            stmt.execute("CREATE TABLE IF NOT EXISTS ip_bans (ip TEXT PRIMARY KEY,reason TEXT,banned_by TEXT,banned_at BIGINT,expires_at BIGINT,permanent INTEGER)");
            stmt.execute("CREATE TABLE IF NOT EXISTS alt_detections (id INTEGER PRIMARY KEY AUTOINCREMENT,player_uuid TEXT,alt_uuid TEXT,shared_ip TEXT,detected_at BIGINT,confidence REAL)");
            stmt.execute("CREATE TABLE IF NOT EXISTS playtime_data (uuid TEXT PRIMARY KEY,username TEXT,total_playtime BIGINT,session_start BIGINT,last_activity BIGINT,is_online INTEGER)");
            stmt.execute("CREATE TABLE IF NOT EXISTS punishments (id TEXT PRIMARY KEY,target_uuid TEXT,target_name TEXT,type TEXT,reason TEXT,issuer_uuid TEXT,issuer_name TEXT,issued_at BIGINT,expires_at BIGINT,is_active INTEGER,removed_by TEXT,removed_at BIGINT)");
            stmt.execute("CREATE TABLE IF NOT EXISTS log_entries (id INTEGER PRIMARY KEY AUTOINCREMENT,timestamp BIGINT,player_uuid TEXT,player_name TEXT,action TEXT,details TEXT,world TEXT,x REAL,y REAL,z REAL)");
            stmt.execute("CREATE TABLE IF NOT EXISTS block_logs (id INTEGER PRIMARY KEY AUTOINCREMENT,timestamp BIGINT,player_uuid TEXT,player_name TEXT,action TEXT,world TEXT,x INTEGER,y INTEGER,z INTEGER,block_type TEXT,block_data TEXT)");
        }
    }

    @Override
    public void savePlayerIPData(PlayerIPData data) {
        String sql = "INSERT OR REPLACE INTO player_ip_data VALUES (?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, data.getUuid().toString());
            pstmt.setString(2, data.getUsername());
            pstmt.setString(3, data.getCurrentIP());
            pstmt.setString(4, String.join((CharSequence)",", data.getIpHistory()));
            pstmt.setLong(5, data.getFirstJoin());
            pstmt.setLong(6, data.getLastJoin());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to save player IP data: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PlayerIPData loadPlayerIPData(UUID uuid) {
        String sql = "SELECT * FROM player_ip_data WHERE uuid = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            PlayerIPData playerIPData = this.extractPlayerIPData(rs);
            return playerIPData;
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load player IP data: " + e.getMessage());
        }
        return null;
    }

    @Override
    public List<PlayerIPData> loadAllPlayerIPData() {
        ArrayList<PlayerIPData> data = new ArrayList<PlayerIPData>();
        String sql = "SELECT * FROM player_ip_data";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                data.add(this.extractPlayerIPData(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load all player IP data: " + e.getMessage());
        }
        return data;
    }

    @Override
    public void deletePlayerIPData(UUID uuid) {
        String sql = "DELETE FROM player_ip_data WHERE uuid = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to delete player IP data: " + e.getMessage());
        }
    }

    private PlayerIPData extractPlayerIPData(ResultSet rs) throws SQLException {
        UUID uuid = UUID.fromString(rs.getString("uuid"));
        String username = rs.getString("username");
        String currentIP = rs.getString("current_ip");
        String[] ipHistory = rs.getString("ip_history").split(",");
        long firstJoin = rs.getLong("first_join");
        long lastJoin = rs.getLong("last_join");
        PlayerIPData data = new PlayerIPData(uuid, username);
        data.setCurrentIP(currentIP);
        for (String ip : ipHistory) {
            if (ip.isEmpty()) continue;
            data.addIP(ip);
        }
        data.setFirstJoin(firstJoin);
        data.setLastJoin(lastJoin);
        return data;
    }

    @Override
    public void saveIPBan(IPBan ban) {
        String sql = "INSERT OR REPLACE INTO ip_bans VALUES (?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, ban.getIp());
            pstmt.setString(2, ban.getReason());
            pstmt.setString(3, ban.getBannedBy());
            pstmt.setLong(4, ban.getBannedAt());
            pstmt.setLong(5, ban.getExpiresAt());
            pstmt.setInt(6, ban.isPermanent() ? 1 : 0);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to save IP ban: " + e.getMessage());
        }
    }

    @Override
    public void removeIPBan(String ip) {
        String sql = "DELETE FROM ip_bans WHERE ip = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, ip);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to remove IP ban: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IPBan loadIPBan(String ip) {
        String sql = "SELECT * FROM ip_bans WHERE ip = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, ip);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            IPBan iPBan = this.extractIPBan(rs);
            return iPBan;
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load IP ban: " + e.getMessage());
        }
        return null;
    }

    @Override
    public List<IPBan> loadAllIPBans() {
        ArrayList<IPBan> bans = new ArrayList<IPBan>();
        String sql = "SELECT * FROM ip_bans";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                bans.add(this.extractIPBan(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load all IP bans: " + e.getMessage());
        }
        return bans;
    }

    private IPBan extractIPBan(ResultSet rs) throws SQLException {
        String ip = rs.getString("ip");
        String reason = rs.getString("reason");
        String bannedBy = rs.getString("banned_by");
        long bannedAt = rs.getLong("banned_at");
        long expiresAt = rs.getLong("expires_at");
        boolean permanent = rs.getInt("permanent") == 1;
        return new IPBan(ip, reason, bannedBy, bannedAt, expiresAt, permanent);
    }

    @Override
    public void saveAltDetection(AltDetection detection) {
        String sql = "INSERT INTO alt_detections (player_uuid, alt_uuid, shared_ip, detected_at, confidence) VALUES (?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, detection.getPlayerUuid().toString());
            pstmt.setString(2, detection.getAltUuid().toString());
            pstmt.setString(3, detection.getSharedIP());
            pstmt.setLong(4, detection.getDetectedAt());
            pstmt.setDouble(5, detection.getConfidence());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to save alt detection: " + e.getMessage());
        }
    }

    @Override
    public List<AltDetection> loadAltDetections(UUID uuid) {
        ArrayList<AltDetection> detections = new ArrayList<AltDetection>();
        String sql = "SELECT * FROM alt_detections WHERE player_uuid = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                detections.add(this.extractAltDetection(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load alt detections: " + e.getMessage());
        }
        return detections;
    }

    @Override
    public List<AltDetection> loadAllAltDetections() {
        ArrayList<AltDetection> detections = new ArrayList<AltDetection>();
        String sql = "SELECT * FROM alt_detections";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                detections.add(this.extractAltDetection(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load all alt detections: " + e.getMessage());
        }
        return detections;
    }

    private AltDetection extractAltDetection(ResultSet rs) throws SQLException {
        UUID playerUuid = UUID.fromString(rs.getString("player_uuid"));
        UUID altUuid = UUID.fromString(rs.getString("alt_uuid"));
        String sharedIP = rs.getString("shared_ip");
        long detectedAt = rs.getLong("detected_at");
        double confidence = rs.getDouble("confidence");
        return new AltDetection(playerUuid, altUuid, sharedIP, detectedAt, confidence);
    }

    @Override
    public void savePlaytimeData(PlaytimeData data) {
        String sql = "INSERT OR REPLACE INTO playtime_data VALUES (?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, data.getUuid().toString());
            pstmt.setString(2, data.getUsername());
            pstmt.setLong(3, data.getTotalPlaytime());
            pstmt.setLong(4, data.getSessionStart());
            pstmt.setLong(5, data.getLastActivity());
            pstmt.setInt(6, data.isOnline() ? 1 : 0);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to save playtime data: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PlaytimeData loadPlaytimeData(UUID uuid) {
        String sql = "SELECT * FROM playtime_data WHERE uuid = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            PlaytimeData playtimeData = this.extractPlaytimeData(rs);
            return playtimeData;
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load playtime data: " + e.getMessage());
        }
        return null;
    }

    @Override
    public List<PlaytimeData> loadAllPlaytimeData() {
        ArrayList<PlaytimeData> data = new ArrayList<PlaytimeData>();
        String sql = "SELECT * FROM playtime_data";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                data.add(this.extractPlaytimeData(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load all playtime data: " + e.getMessage());
        }
        return data;
    }

    @Override
    public void deletePlaytimeData(UUID uuid) {
        String sql = "DELETE FROM playtime_data WHERE uuid = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to delete playtime data: " + e.getMessage());
        }
    }

    private PlaytimeData extractPlaytimeData(ResultSet rs) throws SQLException {
        UUID uuid = UUID.fromString(rs.getString("uuid"));
        String username = rs.getString("username");
        long totalPlaytime = rs.getLong("total_playtime");
        long sessionStart = rs.getLong("session_start");
        long lastActivity = rs.getLong("last_activity");
        boolean isOnline = rs.getInt("is_online") == 1;
        PlaytimeData data = new PlaytimeData(uuid, username);
        data.setTotalPlaytime(totalPlaytime);
        data.setSessionStart(sessionStart);
        data.setLastActivity(lastActivity);
        data.setOnline(isOnline);
        return data;
    }

    @Override
    public void savePunishment(Punishment punishment) {
        String sql = "INSERT OR REPLACE INTO punishments VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, punishment.getId());
            pstmt.setString(2, punishment.getTargetUuid().toString());
            pstmt.setString(3, punishment.getTargetName());
            pstmt.setString(4, punishment.getType().name());
            pstmt.setString(5, punishment.getReason());
            pstmt.setString(6, punishment.getIssuerUuid() != null ? punishment.getIssuerUuid().toString() : null);
            pstmt.setString(7, punishment.getIssuerName());
            pstmt.setLong(8, punishment.getIssuedAt());
            pstmt.setLong(9, punishment.getExpiresAt());
            pstmt.setInt(10, punishment.isActive() ? 1 : 0);
            pstmt.setString(11, punishment.getRemovedBy());
            pstmt.setLong(12, punishment.getRemovedAt());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to save punishment: " + e.getMessage());
        }
    }

    @Override
    public void updatePunishment(Punishment punishment) {
        this.savePunishment(punishment);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Punishment loadPunishment(String punishmentId) {
        String sql = "SELECT * FROM punishments WHERE id = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, punishmentId);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) return null;
            Punishment punishment = this.extractPunishment(rs);
            return punishment;
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load punishment: " + e.getMessage());
        }
        return null;
    }

    @Override
    public List<Punishment> loadPlayerPunishments(UUID uuid) {
        ArrayList<Punishment> punishments = new ArrayList<Punishment>();
        String sql = "SELECT * FROM punishments WHERE target_uuid = ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                punishments.add(this.extractPunishment(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load player punishments: " + e.getMessage());
        }
        return punishments;
    }

    @Override
    public List<Punishment> loadActivePunishments() {
        ArrayList<Punishment> punishments = new ArrayList<Punishment>();
        String sql = "SELECT * FROM punishments WHERE is_active = 1";
        try (Statement stmt = this.connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                punishments.add(this.extractPunishment(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load active punishments: " + e.getMessage());
        }
        return punishments;
    }

    private Punishment extractPunishment(ResultSet rs) throws SQLException {
        String id = rs.getString("id");
        UUID targetUuid = UUID.fromString(rs.getString("target_uuid"));
        String targetName = rs.getString("target_name");
        Punishment.PunishmentType type = Punishment.PunishmentType.valueOf(rs.getString("type"));
        String reason = rs.getString("reason");
        String issuerUuidStr = rs.getString("issuer_uuid");
        UUID issuerUuid = issuerUuidStr != null ? UUID.fromString(issuerUuidStr) : null;
        String issuerName = rs.getString("issuer_name");
        long issuedAt = rs.getLong("issued_at");
        long expiresAt = rs.getLong("expires_at");
        boolean isActive = rs.getInt("is_active") == 1;
        String removedBy = rs.getString("removed_by");
        long removedAt = rs.getLong("removed_at");
        Punishment punishment = new Punishment(id, targetUuid, targetName, type, reason, issuerUuid, issuerName, issuedAt, expiresAt);
        punishment.setActive(isActive);
        punishment.setRemovedBy(removedBy);
        punishment.setRemovedAt(removedAt);
        return punishment;
    }

    @Override
    public void saveLogEntry(LogEntry entry) {
        String sql = "INSERT INTO log_entries (timestamp, player_uuid, player_name, action, details, world, x, y, z) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setLong(1, entry.getTimestamp());
            pstmt.setString(2, entry.getPlayerUuid() != null ? entry.getPlayerUuid().toString() : null);
            pstmt.setString(3, entry.getPlayerName());
            pstmt.setString(4, entry.getAction());
            pstmt.setString(5, entry.getDetails());
            pstmt.setString(6, entry.getWorld());
            pstmt.setDouble(7, entry.getX());
            pstmt.setDouble(8, entry.getY());
            pstmt.setDouble(9, entry.getZ());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to save log entry: " + e.getMessage());
        }
    }

    @Override
    public List<LogEntry> loadLogEntries(long startTime, long endTime) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        String sql = "SELECT * FROM log_entries WHERE timestamp >= ? AND timestamp <= ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setLong(1, startTime);
            pstmt.setLong(2, endTime);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                entries.add(this.extractLogEntry(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load log entries: " + e.getMessage());
        }
        return entries;
    }

    @Override
    public List<LogEntry> loadPlayerLogs(UUID uuid, int limit) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        String sql = "SELECT * FROM log_entries WHERE player_uuid = ? ORDER BY timestamp DESC LIMIT ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setInt(2, limit);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                entries.add(this.extractLogEntry(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to load player logs: " + e.getMessage());
        }
        return entries;
    }

    private LogEntry extractLogEntry(ResultSet rs) throws SQLException {
        long timestamp = rs.getLong("timestamp");
        String playerUuidStr = rs.getString("player_uuid");
        UUID playerUuid = playerUuidStr != null ? UUID.fromString(playerUuidStr) : null;
        String playerName = rs.getString("player_name");
        String action = rs.getString("action");
        String details = rs.getString("details");
        String world = rs.getString("world");
        double x = rs.getDouble("x");
        double y = rs.getDouble("y");
        double z = rs.getDouble("z");
        return new LogEntry(timestamp, playerUuid, playerName, action, details, world, x, y, z);
    }

    @Override
    public void saveBlockLog(BlockLogEntry entry) {
        String sql = "INSERT INTO block_logs (timestamp, player_uuid, player_name, action, world, x, y, z, block_type, block_data) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setLong(1, entry.getTimestamp());
            pstmt.setString(2, entry.getPlayerUuid().toString());
            pstmt.setString(3, entry.getPlayerName());
            pstmt.setString(4, entry.getAction().name());
            pstmt.setString(5, entry.getWorld());
            pstmt.setInt(6, entry.getX());
            pstmt.setInt(7, entry.getY());
            pstmt.setInt(8, entry.getZ());
            pstmt.setString(9, entry.getBlockType());
            pstmt.setString(10, entry.getBlockData());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to save block log: " + e.getMessage());
        }
    }

    @Override
    public List<BlockLogEntry> lookupBlockLogs(Location location, int radius, long startTime) {
        ArrayList<BlockLogEntry> entries = new ArrayList<BlockLogEntry>();
        String sql = "SELECT * FROM block_logs WHERE world = ? AND x BETWEEN ? AND ? AND y BETWEEN ? AND ? AND z BETWEEN ? AND ? AND timestamp >= ?";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, location.getWorld().getName());
            pstmt.setInt(2, location.getBlockX() - radius);
            pstmt.setInt(3, location.getBlockX() + radius);
            pstmt.setInt(4, location.getBlockY() - radius);
            pstmt.setInt(5, location.getBlockY() + radius);
            pstmt.setInt(6, location.getBlockZ() - radius);
            pstmt.setInt(7, location.getBlockZ() + radius);
            pstmt.setLong(8, startTime);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                entries.add(this.extractBlockLogEntry(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to lookup block logs: " + e.getMessage());
        }
        return entries;
    }

    @Override
    public List<BlockLogEntry> lookupPlayerBlockLogs(UUID playerId, long startTime) {
        ArrayList<BlockLogEntry> entries = new ArrayList<BlockLogEntry>();
        String sql = "SELECT * FROM block_logs WHERE player_uuid = ? AND timestamp >= ? ORDER BY timestamp DESC";
        try (PreparedStatement pstmt = this.connection.prepareStatement(sql);){
            pstmt.setString(1, playerId.toString());
            pstmt.setLong(2, startTime);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                entries.add(this.extractBlockLogEntry(rs));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Failed to lookup player block logs: " + e.getMessage());
        }
        return entries;
    }

    private BlockLogEntry extractBlockLogEntry(ResultSet rs) throws SQLException {
        long timestamp = rs.getLong("timestamp");
        UUID playerUuid = UUID.fromString(rs.getString("player_uuid"));
        String playerName = rs.getString("player_name");
        BlockAction action = BlockAction.valueOf(rs.getString("action"));
        String world = rs.getString("world");
        int x = rs.getInt("x");
        int y = rs.getInt("y");
        int z = rs.getInt("z");
        String blockType = rs.getString("block_type");
        String blockData = rs.getString("block_data");
        return new BlockLogEntry(timestamp, playerUuid, playerName, action.name(), world, x, y, z, blockType, blockData);
    }
}

