/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.stress;

import java.util.ArrayList;
import java.util.List;

public class PlayerStressData {
    private int packetsPerSecond;
    private int commandsPerSecond;
    private int chatPerSecond;
    private List<String> recentCommands = new ArrayList<String>();

    public void incrementPackets() {
        ++this.packetsPerSecond;
    }

    public void incrementCommands() {
        ++this.commandsPerSecond;
    }

    public void incrementChat() {
        ++this.chatPerSecond;
    }

    public void addCommand(String command) {
        this.recentCommands.add(command);
        if (this.recentCommands.size() > 10) {
            this.recentCommands.remove(0);
        }
    }

    public void reset() {
        this.packetsPerSecond = 0;
        this.commandsPerSecond = 0;
        this.chatPerSecond = 0;
    }

    public int getPacketsPerSecond() {
        return this.packetsPerSecond;
    }

    public int getCommandsPerSecond() {
        return this.commandsPerSecond;
    }

    public int getChatPerSecond() {
        return this.chatPerSecond;
    }

    public List<String> getRecentCommands() {
        return new ArrayList<String>(this.recentCommands);
    }
}

