/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.stress;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.stress.PlayerStressData;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class StressDetector {
    private final UnifiedSecureMgr plugin;
    private final Map<UUID, PlayerStressData> playerData;
    private final Map<String, Integer> globalPacketCount;
    private final Map<String, Integer> globalCommandCount;
    private long lastResetTime;
    private int totalPacketsPerSecond;
    private int totalCommandsPerSecond;

    public StressDetector(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.playerData = new ConcurrentHashMap<UUID, PlayerStressData>();
        this.globalPacketCount = new ConcurrentHashMap<String, Integer>();
        this.globalCommandCount = new ConcurrentHashMap<String, Integer>();
        this.lastResetTime = System.currentTimeMillis();
        this.startMonitoring();
    }

    private void startMonitoring() {
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            this.analyzeStress();
            this.resetCounters();
        }, 20L, 20L);
    }

    public void recordPacket(Player player) {
        PlayerStressData data = this.playerData.computeIfAbsent(player.getUniqueId(), k -> new PlayerStressData());
        data.incrementPackets();
        ++this.totalPacketsPerSecond;
    }

    public void recordCommand(Player player, String command) {
        PlayerStressData data = this.playerData.computeIfAbsent(player.getUniqueId(), k -> new PlayerStressData());
        data.incrementCommands();
        data.addCommand(command);
        ++this.totalCommandsPerSecond;
    }

    public void recordChat(Player player) {
        PlayerStressData data = this.playerData.computeIfAbsent(player.getUniqueId(), k -> new PlayerStressData());
        data.incrementChat();
    }

    private void analyzeStress() {
        int packetThreshold = this.plugin.getConfigManager().getConfig().getInt("stress.packetThreshold", 1000);
        int commandThreshold = this.plugin.getConfigManager().getConfig().getInt("stress.commandThreshold", 50);
        int playerPacketThreshold = this.plugin.getConfigManager().getConfig().getInt("stress.playerPacketThreshold", 100);
        int playerCommandThreshold = this.plugin.getConfigManager().getConfig().getInt("stress.playerCommandThreshold", 10);
        if (this.totalPacketsPerSecond > packetThreshold) {
            this.alertStaff("\u00a7c[Stress] High packet rate detected: " + this.totalPacketsPerSecond + "/s");
            if (this.plugin.getLoggerService() != null) {
                this.plugin.getLoggerService().logSecurity("STRESS_PACKETS", "High packet rate: " + this.totalPacketsPerSecond);
            }
        }
        if (this.totalCommandsPerSecond > commandThreshold) {
            this.alertStaff("\u00a7c[Stress] High command rate detected: " + this.totalCommandsPerSecond + "/s");
            if (this.plugin.getLoggerService() != null) {
                this.plugin.getLoggerService().logSecurity("STRESS_COMMANDS", "High command rate: " + this.totalCommandsPerSecond);
            }
        }
        for (Map.Entry<UUID, PlayerStressData> entry : this.playerData.entrySet()) {
            PlayerStressData data = entry.getValue();
            Player player = this.plugin.getServer().getPlayer(entry.getKey());
            if (player == null) continue;
            if (data.getPacketsPerSecond() > playerPacketThreshold) {
                this.alertStaff("\u00a7c[Stress] " + player.getName() + " high packet rate: " + data.getPacketsPerSecond() + "/s");
                if (this.plugin.getConfigManager().getConfig().getBoolean("stress.autoKickPacketSpam", false)) {
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.kickPlayer("\u00a7cPacket spam detected"));
                }
            }
            if (data.getCommandsPerSecond() > playerCommandThreshold) {
                this.alertStaff("\u00a7c[Stress] " + player.getName() + " command spam: " + data.getCommandsPerSecond() + "/s");
                if (this.plugin.getConfigManager().getConfig().getBoolean("stress.autoKickCommandSpam", false)) {
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.kickPlayer("\u00a7cCommand spam detected"));
                }
            }
            if (data.getChatPerSecond() <= 5) continue;
            this.alertStaff("\u00a7c[Stress] " + player.getName() + " chat spam: " + data.getChatPerSecond() + "/s");
        }
    }

    private void resetCounters() {
        this.totalPacketsPerSecond = 0;
        this.totalCommandsPerSecond = 0;
        for (PlayerStressData data : this.playerData.values()) {
            data.reset();
        }
        this.lastResetTime = System.currentTimeMillis();
    }

    private void alertStaff(String message) {
        this.plugin.getServer().getOnlinePlayers().stream().filter(p -> p.hasPermission("unified.stress.alerts")).forEach(p -> p.sendMessage(message));
    }

    public PlayerStressData getPlayerData(UUID uuid) {
        return this.playerData.get(uuid);
    }

    public int getTotalPacketsPerSecond() {
        return this.totalPacketsPerSecond;
    }

    public int getTotalCommandsPerSecond() {
        return this.totalCommandsPerSecond;
    }
}

