/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.trust;

import java.util.ArrayList;
import java.util.List;

public class TrustHistory {
    private final List<TrustEntry> entries = new ArrayList<TrustEntry>();

    public void addEntry(int change, String reason) {
        this.entries.add(new TrustEntry(System.currentTimeMillis(), change, reason));
        if (this.entries.size() > 100) {
            this.entries.remove(0);
        }
    }

    public List<TrustEntry> getEntries() {
        return new ArrayList<TrustEntry>(this.entries);
    }

    public List<TrustEntry> getRecentEntries(int count) {
        int size = this.entries.size();
        int start = Math.max(0, size - count);
        return new ArrayList<TrustEntry>(this.entries.subList(start, size));
    }

    public static class TrustEntry {
        private final long timestamp;
        private final int change;
        private final String reason;

        public TrustEntry(long timestamp, int change, String reason) {
            this.timestamp = timestamp;
            this.change = change;
            this.reason = reason;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getChange() {
            return this.change;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

