/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.trust;

import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.trust.TrustHistory;
import com.unifiedsecure.trust.TrustLevel;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class TrustSystem {
    private final UnifiedSecureMgr plugin;
    private final Map<UUID, Integer> trustScores;
    private final Map<UUID, TrustHistory> trustHistory;
    private final Set<UUID> trustedPermissionGranted;

    public TrustSystem(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.trustScores = new ConcurrentHashMap<UUID, Integer>();
        this.trustHistory = new ConcurrentHashMap<UUID, TrustHistory>();
        this.trustedPermissionGranted = ConcurrentHashMap.newKeySet();
    }

    public void initializePlayer(UUID uuid) {
        this.trustScores.putIfAbsent(uuid, 50);
        this.trustHistory.putIfAbsent(uuid, new TrustHistory());
    }

    public void adjustTrust(UUID uuid, int amount, String reason) {
        int current = this.trustScores.getOrDefault(uuid, 50);
        int newScore = Math.max(0, Math.min(100, current + amount));
        this.trustScores.put(uuid, newScore);
        TrustHistory history = this.trustHistory.computeIfAbsent(uuid, k -> new TrustHistory());
        history.addEntry(amount, reason);
        if (this.plugin.getLoggerService() != null) {
            this.plugin.getLoggerService().logSecurity("TRUST_CHANGE", String.valueOf(uuid) + " trust: " + current + " -> " + newScore + " (" + reason + ")");
        }
        this.checkTrustLevel(uuid, newScore);
    }

    private void checkTrustLevel(UUID uuid, int score) {
        if (score <= 20) {
            this.alertStaff("\u00a7c[Trust] Player " + this.plugin.getServer().getOfflinePlayer(uuid).getName() + " has very low trust (" + score + ")");
        } else if (score >= 80) {
            if (this.plugin.getConfigManager().getConfig().getBoolean("trust.rewardHighTrust", true) && !this.trustedPermissionGranted.contains(uuid)) {
                this.trustedPermissionGranted.add(uuid);
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "lp user " + this.plugin.getServer().getOfflinePlayer(uuid).getName() + " permission set unified.trusted true"));
            }
        } else if (score < 80 && this.trustedPermissionGranted.contains(uuid)) {
            this.trustedPermissionGranted.remove(uuid);
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "lp user " + this.plugin.getServer().getOfflinePlayer(uuid).getName() + " permission unset unified.trusted"));
        }
    }

    public int getTrustScore(UUID uuid) {
        return this.trustScores.getOrDefault(uuid, 50);
    }

    public TrustLevel getTrustLevel(UUID uuid) {
        int score = this.getTrustScore(uuid);
        if (score >= 80) {
            return TrustLevel.TRUSTED;
        }
        if (score >= 60) {
            return TrustLevel.RELIABLE;
        }
        if (score >= 40) {
            return TrustLevel.NEUTRAL;
        }
        if (score >= 20) {
            return TrustLevel.SUSPICIOUS;
        }
        return TrustLevel.UNTRUSTED;
    }

    public void recordPositiveAction(UUID uuid, String action) {
        int amount = this.plugin.getConfigManager().getConfig().getInt("trust.positiveActions." + action, 1);
        this.adjustTrust(uuid, amount, "Positive: " + action);
    }

    public void recordNegativeAction(UUID uuid, String action) {
        int amount = this.plugin.getConfigManager().getConfig().getInt("trust.negativeActions." + action, -5);
        this.adjustTrust(uuid, amount, "Negative: " + action);
    }

    public TrustHistory getHistory(UUID uuid) {
        return this.trustHistory.get(uuid);
    }

    private void alertStaff(String message) {
        this.plugin.getServer().getOnlinePlayers().stream().filter(p -> p.hasPermission("unified.trust.alerts")).forEach(p -> p.sendMessage(message));
    }

    public Map<UUID, Integer> getAllScores() {
        return new ConcurrentHashMap<UUID, Integer>(this.trustScores);
    }
}

