/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.util;

import com.unifiedsecure.UnifiedSecureMgr;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class AsyncUtil {
    private final UnifiedSecureMgr plugin;
    private final ExecutorService executor;
    private final BlockingQueue<Runnable> taskQueue;

    public AsyncUtil(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        int poolSize = plugin.getConfigManager().getThreadPoolSize();
        int queueCapacity = plugin.getConfigManager().getAsyncQueueCapacity();
        this.taskQueue = new LinkedBlockingQueue<Runnable>(queueCapacity);
        this.executor = new ThreadPoolExecutor(poolSize, poolSize * 2, 60L, TimeUnit.SECONDS, this.taskQueue, new ThreadFactory(this){
            private int counter = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "UnifiedSecure-Async-" + this.counter++);
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public void runAsync(Runnable task) {
        this.executor.submit(task);
    }

    public <T> CompletableFuture<T> supplyAsync(Callable<T> task) {
        CompletableFuture future = new CompletableFuture();
        this.executor.submit(() -> {
            try {
                future.complete(task.call());
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public void runSync(Runnable task) {
        if (Bukkit.isPrimaryThread()) {
            task.run();
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, task);
        }
    }

    public <T> void supplyAsyncThenSync(Callable<T> asyncTask, Consumer<T> syncTask) {
        this.runAsync(() -> {
            try {
                Object result = asyncTask.call();
                this.runSync(() -> syncTask.accept(result));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error in async task: " + e.getMessage());
            }
        });
    }

    public BukkitTask scheduleAsync(Runnable task, long delayTicks) {
        return Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, task, delayTicks);
    }

    public BukkitTask scheduleAsyncRepeating(Runnable task, long delayTicks, long periodTicks) {
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, task, delayTicks, periodTicks);
    }

    public int getQueueSize() {
        return this.taskQueue.size();
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

