/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class CIDRUtil {
    public static boolean matches(String ip, String cidr) {
        if (cidr.contains("*")) {
            return CIDRUtil.matchesWildcard(ip, cidr);
        }
        if (!cidr.contains("/")) {
            return ip.equals(cidr);
        }
        try {
            int netInt;
            String[] parts = cidr.split("/");
            String network = parts[0];
            int prefix = Integer.parseInt(parts[1]);
            InetAddress ipAddr = InetAddress.getByName(ip);
            InetAddress netAddr = InetAddress.getByName(network);
            if (!(ipAddr instanceof Inet4Address) || !(netAddr instanceof Inet4Address)) {
                return false;
            }
            byte[] ipBytes = ipAddr.getAddress();
            byte[] netBytes = netAddr.getAddress();
            int mask = -1 << 32 - prefix;
            int ipInt = CIDRUtil.bytesToInt(ipBytes);
            return (ipInt & mask) == ((netInt = CIDRUtil.bytesToInt(netBytes)) & mask);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean matchesWildcard(String ip, String pattern) {
        String[] ipParts = ip.split("\\.");
        String[] patternParts = pattern.split("\\.");
        if (ipParts.length != 4 || patternParts.length != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if ("*".equals(patternParts[i]) || ipParts[i].equals(patternParts[i])) continue;
            return false;
        }
        return true;
    }

    public static String wildcardToCIDR(String wildcard) {
        String[] parts = wildcard.split("\\.");
        if (parts.length != 4) {
            return wildcard;
        }
        int prefix = 0;
        StringBuilder network = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if ("*".equals(parts[i])) {
                network.append("0");
            } else {
                network.append(parts[i]);
                prefix += 8;
            }
            if (i >= 3) continue;
            network.append(".");
        }
        return network.toString() + "/" + prefix;
    }

    public static boolean isValidIP(String ip) {
        try {
            InetAddress addr = InetAddress.getByName(ip);
            return addr instanceof Inet4Address;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean isValidCIDR(String cidr) {
        if (!cidr.contains("/")) {
            return false;
        }
        try {
            String[] parts = cidr.split("/");
            int prefix = Integer.parseInt(parts[1]);
            return prefix >= 0 && prefix <= 32 && CIDRUtil.isValidIP(parts[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String obfuscateIP(String ip) {
        String[] parts = ip.split("\\.");
        if (parts.length == 4) {
            return parts[0] + "." + parts[1] + "." + parts[2] + ".***";
        }
        return ip;
    }

    private static int bytesToInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }
}

