/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class JsonUtils {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Gson COMPACT_GSON = new GsonBuilder().disableHtmlEscaping().create();

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return (T)GSON.fromJson(json, classOfT);
    }

    public static <T> T fromJson(File file, Class<T> classOfT) throws IOException {
        if (!file.exists()) {
            return null;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            Object object = GSON.fromJson((Reader)reader, classOfT);
            return (T)object;
        }
    }

    public static String toJson(Object obj) {
        return GSON.toJson(obj);
    }

    public static String toCompactJson(Object obj) {
        return COMPACT_GSON.toJson(obj);
    }

    public static void toJsonFile(Object obj, File file) throws IOException {
        file.getParentFile().mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            GSON.toJson(obj, (Appendable)writer);
        }
    }

    public static JsonObject parseObject(String json) {
        return JsonParser.parseString((String)json).getAsJsonObject();
    }

    public static boolean isValidJson(String json) {
        try {
            JsonParser.parseString((String)json);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

