/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.vanish;

import com.unifiedsecure.UnifiedSecureMgr;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class VanishManager {
    private final UnifiedSecureMgr plugin;
    private final Set<UUID> vanished;
    private final Set<UUID> silentChest;
    private final Set<UUID> noPickup;

    public VanishManager(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.vanished = new HashSet<UUID>();
        this.silentChest = new HashSet<UUID>();
        this.noPickup = new HashSet<UUID>();
    }

    public void vanish(Player player) {
        this.vanished.add(player.getUniqueId());
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (online.hasPermission("unified.vanish.see")) continue;
            online.hidePlayer((Plugin)this.plugin, player);
        }
        if (this.plugin.getConfigManager().getConfig().getBoolean("vanish.nightVision", true)) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, 0, false, false));
        }
        if (this.plugin.getConfigManager().getConfig().getBoolean("vanish.silentChest", true)) {
            this.silentChest.add(player.getUniqueId());
        }
        if (this.plugin.getConfigManager().getConfig().getBoolean("vanish.noPickup", true)) {
            this.noPickup.add(player.getUniqueId());
        }
        player.sendMessage("\u00a7aYou are now vanished");
        if (this.plugin.getLoggerService() != null) {
            this.plugin.getLoggerService().logStaff(player.getUniqueId(), "VANISH_ENABLE", "");
        }
    }

    public void unvanish(Player player) {
        this.vanished.remove(player.getUniqueId());
        this.silentChest.remove(player.getUniqueId());
        this.noPickup.remove(player.getUniqueId());
        for (Player online : Bukkit.getOnlinePlayers()) {
            online.showPlayer((Plugin)this.plugin, player);
        }
        player.removePotionEffect(PotionEffectType.NIGHT_VISION);
        player.sendMessage("\u00a7cYou are no longer vanished");
        if (this.plugin.getLoggerService() != null) {
            this.plugin.getLoggerService().logStaff(player.getUniqueId(), "VANISH_DISABLE", "");
        }
    }

    public void toggle(Player player) {
        if (this.isVanished(player)) {
            this.unvanish(player);
        } else {
            this.vanish(player);
        }
    }

    public boolean isVanished(Player player) {
        return this.vanished.contains(player.getUniqueId());
    }

    public boolean isVanished(UUID uuid) {
        return this.vanished.contains(uuid);
    }

    public boolean hasSilentChest(UUID uuid) {
        return this.silentChest.contains(uuid);
    }

    public boolean hasNoPickup(UUID uuid) {
        return this.noPickup.contains(uuid);
    }

    public Set<UUID> getVanished() {
        return new HashSet<UUID>(this.vanished);
    }

    public void handleJoin(Player player) {
        for (UUID uuid : this.vanished) {
            Player vanishedPlayer = Bukkit.getPlayer((UUID)uuid);
            if (vanishedPlayer == null || player.hasPermission("unified.vanish.see")) continue;
            player.hidePlayer((Plugin)this.plugin, vanishedPlayer);
        }
    }

    public int getVanishedCount() {
        return this.vanished.size();
    }
}

