/*
 * Decompiled with CFR 0.152.
 */
package com.unifiedsecure.vpn;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.unifiedsecure.UnifiedSecureMgr;
import com.unifiedsecure.vpn.VPNCheckResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VPNDetector {
    private final UnifiedSecureMgr plugin;
    private final Map<String, VPNCheckResult> cache;
    private final Map<String, Long> rateLimiter;

    public VPNDetector(UnifiedSecureMgr plugin) {
        this.plugin = plugin;
        this.cache = new ConcurrentHashMap<String, VPNCheckResult>();
        this.rateLimiter = new ConcurrentHashMap<String, Long>();
    }

    public void checkAsync(String ip, VPNCheckCallback callback) {
        this.plugin.getAsyncUtil().runAsync(() -> {
            VPNCheckResult result = this.check(ip);
            this.plugin.getAsyncUtil().runSync(() -> callback.onResult(result));
        });
    }

    public VPNCheckResult check(String ip) {
        if (this.cache.containsKey(ip)) {
            VPNCheckResult cached = this.cache.get(ip);
            if (System.currentTimeMillis() - cached.getTimestamp() < this.getCacheDuration()) {
                return cached;
            }
        }
        if (this.rateLimiter.containsKey(ip)) {
            long lastCheck = this.rateLimiter.get(ip);
            if (System.currentTimeMillis() - lastCheck < this.getRateLimit()) {
                return this.cache.getOrDefault(ip, new VPNCheckResult(ip, false, false, false, "Rate limited"));
            }
        }
        VPNCheckResult result = this.performCheck(ip);
        this.cache.put(ip, result);
        this.rateLimiter.put(ip, System.currentTimeMillis());
        return result;
    }

    private VPNCheckResult performCheck(String ip) {
        String apiType = this.plugin.getConfigManager().getConfig().getString("vpn.apiType", "PROXYCHECK");
        try {
            switch (apiType.toUpperCase()) {
                case "PROXYCHECK": {
                    return this.checkProxyCheck(ip);
                }
                case "IPQUALITYSCORE": {
                    return this.checkIPQualityScore(ip);
                }
                case "VPNAPI": {
                    return this.checkVPNAPI(ip);
                }
                case "IPHUB": {
                    return this.checkIPHub(ip);
                }
            }
            return this.checkProxyCheck(ip);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("VPN check failed for " + ip + ": " + e.getMessage());
            return new VPNCheckResult(ip, false, false, false, "Check failed: " + e.getMessage());
        }
    }

    private VPNCheckResult checkProxyCheck(String ip) throws Exception {
        String apiKey = this.plugin.getConfigManager().getConfig().getString("vpn.proxycheck.apiKey", "");
        String urlStr = "http://proxycheck.io/v2/" + ip + "?key=" + apiKey + "&vpn=1&asn=1";
        JsonObject json = this.makeRequest(urlStr);
        JsonObject ipData = json.getAsJsonObject(ip);
        boolean isProxy = ipData.has("proxy") && ipData.get("proxy").getAsString().equals("yes");
        boolean isVPN = ipData.has("type") && ipData.get("type").getAsString().contains("VPN");
        return new VPNCheckResult(ip, isProxy, isVPN, false, "ProxyCheck.io");
    }

    private VPNCheckResult checkIPQualityScore(String ip) throws Exception {
        String apiKey = this.plugin.getConfigManager().getConfig().getString("vpn.ipqualityscore.apiKey", "");
        String urlStr = "https://ipqualityscore.com/api/json/ip/" + apiKey + "/" + ip + "?strictness=1";
        JsonObject json = this.makeRequest(urlStr);
        boolean isProxy = json.has("proxy") && json.get("proxy").getAsBoolean();
        boolean isVPN = json.has("vpn") && json.get("vpn").getAsBoolean();
        boolean isTor = json.has("tor") && json.get("tor").getAsBoolean();
        return new VPNCheckResult(ip, isProxy, isVPN, isTor, "IPQualityScore");
    }

    private VPNCheckResult checkVPNAPI(String ip) throws Exception {
        String apiKey = this.plugin.getConfigManager().getConfig().getString("vpn.vpnapi.apiKey", "");
        String urlStr = "https://vpnapi.io/api/" + ip + "?key=" + apiKey;
        JsonObject json = this.makeRequest(urlStr);
        JsonObject security = json.getAsJsonObject("security");
        boolean isVPN = security.has("vpn") && security.get("vpn").getAsBoolean();
        boolean isProxy = security.has("proxy") && security.get("proxy").getAsBoolean();
        boolean isTor = security.has("tor") && security.get("tor").getAsBoolean();
        return new VPNCheckResult(ip, isProxy, isVPN, isTor, "VPNAPI.io");
    }

    private VPNCheckResult checkIPHub(String ip) throws Exception {
        String line;
        String apiKey = this.plugin.getConfigManager().getConfig().getString("vpn.iphub.apiKey", "");
        String urlStr = "http://v2.api.iphub.info/ip/" + ip;
        HttpURLConnection conn = (HttpURLConnection)new URL(urlStr).openConnection();
        conn.setRequestProperty("X-Key", apiKey);
        conn.setRequestMethod("GET");
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
        }
        reader.close();
        JsonObject json = JsonParser.parseString((String)response.toString()).getAsJsonObject();
        int block = json.has("block") ? json.get("block").getAsInt() : 0;
        boolean isProxy = block == 1;
        boolean isVPN = block == 1;
        return new VPNCheckResult(ip, isProxy, isVPN, false, "IPHub");
    }

    private JsonObject makeRequest(String urlStr) throws Exception {
        String line;
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
        }
        reader.close();
        return JsonParser.parseString((String)response.toString()).getAsJsonObject();
    }

    private long getCacheDuration() {
        return this.plugin.getConfigManager().getConfig().getLong("vpn.cacheDurationMs", 86400000L);
    }

    private long getRateLimit() {
        return this.plugin.getConfigManager().getConfig().getLong("vpn.rateLimitMs", 1000L);
    }

    public void clearCache() {
        this.cache.clear();
    }

    public static interface VPNCheckCallback {
        public void onResult(VPNCheckResult var1);
    }
}

