/*
 * Decompiled with CFR 0.152.
 */
package com.periut.factoryblocks.block;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.periut.factoryblocks.TooltipBlockItem;
import com.periut.factoryblocks.block.BaseFactoryBlock;
import com.periut.factoryblocks.block.fan.BaseFanBlock;
import com.periut.factoryblocks.block.fan.MediumFanBlock;
import com.periut.factoryblocks.block.fan.RedstoneFanBlock;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class RegisterBlocks {
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)"factory_blocks"));
    public static ArrayList<RegistrySupplier<Item>> itemSuppliers = new ArrayList();

    private static void addFactoryBlock(String nameID, Type type) {
        RegisterBlocks.addFactoryBlock(nameID, type, true);
    }

    private static void addFactoryBlock(String nameID, Type type, boolean include) {
        ResourceLocation blockID = ResourceLocation.m_214293_((String)"factory_blocks", (String)nameID);
        Registrar blocks = ((RegistrarManager)MANAGER.get()).get((Registry)BuiltInRegistries.f_256975_);
        RegistrySupplier blockSupplier = switch (type) {
            default -> blocks.register(blockID, () -> new BaseFactoryBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
            case Type.baseFan -> blocks.register(blockID, () -> new BaseFanBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
            case Type.redFan -> blocks.register(blockID, () -> new RedstoneFanBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
            case Type.mediumFan -> blocks.register(blockID, () -> new MediumFanBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
        };
        Registrar items = ((RegistrarManager)MANAGER.get()).get((Registry)BuiltInRegistries.f_257033_);
        itemSuppliers.add((RegistrySupplier<Item>)items.register(blockID, () -> new TooltipBlockItem((Block)blockSupplier.get(), new Item.Properties().arch$tab(CreativeModeTabs.f_256788_), nameID + ".tooltip")));
    }

    public static void register() {
        RegisterBlocks.addFactoryBlock("factory", Type.base);
        RegisterBlocks.addFactoryBlock("rust", Type.base);
        RegisterBlocks.addFactoryBlock("vrust", Type.base);
        RegisterBlocks.addFactoryBlock("srust", Type.base);
        RegisterBlocks.addFactoryBlock("wireframe", Type.base);
        RegisterBlocks.addFactoryBlock("pwireframe", Type.base);
        RegisterBlocks.addFactoryBlock("hazard", Type.base);
        RegisterBlocks.addFactoryBlock("hazardo", Type.base);
        RegisterBlocks.addFactoryBlock("circuit", Type.base);
        RegisterBlocks.addFactoryBlock("metalbox", Type.base);
        RegisterBlocks.addFactoryBlock("gcircuit", Type.base);
        RegisterBlocks.addFactoryBlock("pgcircuit", Type.base);
        RegisterBlocks.addFactoryBlock("grinder", Type.base);
        RegisterBlocks.addFactoryBlock("old_vents", Type.base);
        RegisterBlocks.addFactoryBlock("rust_plates", Type.base);
        RegisterBlocks.addFactoryBlock("bcircuit", Type.base);
        RegisterBlocks.addFactoryBlock("ice", Type.base);
        RegisterBlocks.addFactoryBlock("mosaic", Type.base);
        RegisterBlocks.addFactoryBlock("bwireframe", Type.base);
        RegisterBlocks.addFactoryBlock("rusty_scaffold", Type.base);
        RegisterBlocks.addFactoryBlock("caution", Type.base);
        RegisterBlocks.addFactoryBlock("large_pipes", Type.base);
        RegisterBlocks.addFactoryBlock("small_pipes", Type.base);
        RegisterBlocks.addFactoryBlock("vent", Type.base);
        RegisterBlocks.addFactoryBlock("gvent", Type.base);
        RegisterBlocks.addFactoryBlock("insulation", Type.base);
        RegisterBlocks.addFactoryBlock("gears", Type.base);
        RegisterBlocks.addFactoryBlock("cables", Type.base);
        RegisterBlocks.addFactoryBlock("rust_bplates", Type.base);
        RegisterBlocks.addFactoryBlock("grate", Type.base);
        RegisterBlocks.addFactoryBlock("rgrate", Type.base);
        RegisterBlocks.addFactoryBlock("hex", Type.base);
        RegisterBlocks.addFactoryBlock("wgpanel", Type.base);
        RegisterBlocks.addFactoryBlock("wopanel", Type.base);
        RegisterBlocks.addFactoryBlock("sturdy", Type.base);
        RegisterBlocks.addFactoryBlock("megacell", Type.base);
        RegisterBlocks.addFactoryBlock("exhaust", Type.base);
        RegisterBlocks.addFactoryBlock("engineer", Type.base);
        RegisterBlocks.addFactoryBlock("scaffold", Type.base);
        RegisterBlocks.addFactoryBlock("piping", Type.base);
        RegisterBlocks.addFactoryBlock("large_plating", Type.base);
        RegisterBlocks.addFactoryBlock("fan_side", Type.base);
        RegisterBlocks.addFactoryBlock("fan_on", Type.baseFan);
        RegisterBlocks.addFactoryBlock("fan_four_on", Type.baseFan);
        RegisterBlocks.addFactoryBlock("fan_malfunction_on", Type.baseFan);
        RegisterBlocks.addFactoryBlock("fan", Type.redFan);
        RegisterBlocks.addFactoryBlock("fan_four", Type.redFan);
        RegisterBlocks.addFactoryBlock("fan_malfunction", Type.redFan);
        RegisterBlocks.addFactoryBlock("medium_fan", Type.mediumFan, false);
    }

    static enum Type {
        base,
        baseFan,
        redFan,
        mediumFan;

    }
}

