/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.util.TransformationHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelDynamicModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelModelPart;
import net.p3pp3rf1y.sophisticatedstorage.client.render.CompositeElementsModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DynamicBarrelBakingData;
import net.p3pp3rf1y.sophisticatedstorage.client.render.RenderHelper;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.BlockSide;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class BarrelBakedModelBase
implements IDynamicBakedModel {
    private static final IQuadTransformer MOVE_TO_CORNER = QuadTransformers.applying((Transformation)new Transformation(new Vector3f(-0.5f, -0.5f, -0.5f), null, null, null));
    public static final Map<Direction, IQuadTransformer> DIRECTION_ROTATES = Map.of(Direction.UP, BarrelBakedModelBase.getDirectionRotationTransform(Direction.UP), Direction.DOWN, BarrelBakedModelBase.getDirectionRotationTransform(Direction.DOWN), Direction.NORTH, BarrelBakedModelBase.getDirectionRotationTransform(Direction.NORTH), Direction.SOUTH, BarrelBakedModelBase.getDirectionRotationTransform(Direction.SOUTH), Direction.WEST, BarrelBakedModelBase.getDirectionRotationTransform(Direction.WEST), Direction.EAST, BarrelBakedModelBase.getDirectionRotationTransform(Direction.EAST));
    private static final LoadingCache<Direction, Cache<Integer, IQuadTransformer>> DIRECTION_MOVES_3D_ITEMS = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Direction, Cache<Integer, IQuadTransformer>>(){

        public Cache<Integer, IQuadTransformer> load(Direction key) {
            return CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        }
    });
    private static final IQuadTransformer SCALE_BIG_2D_ITEM = QuadTransformers.applying((Transformation)new Transformation(null, null, new Vector3f(0.5f, 0.5f, 0.5f), null));
    private static final IQuadTransformer SCALE_SMALL_3D_ITEM = QuadTransformers.applying((Transformation)new Transformation(null, null, new Vector3f(0.5f, 0.5f, 0.5f), null));
    private static final IQuadTransformer SCALE_SMALL_2D_ITEM = QuadTransformers.applying((Transformation)new Transformation(null, null, new Vector3f(0.25f, 0.25f, 0.25f), null));
    private static final Cache<Integer, IQuadTransformer> DIRECTION_MOVE_BACK_TO_SIDE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private static final ModelProperty<String> WOOD_NAME = new ModelProperty();
    private static final ModelProperty<Boolean> IS_PACKED = new ModelProperty();
    private static final ModelProperty<Boolean> SHOWS_LOCK = new ModelProperty();
    private static final ModelProperty<Boolean> SHOWS_TIER = new ModelProperty();
    private static final ModelProperty<Boolean> HAS_MAIN_COLOR = new ModelProperty();
    private static final ModelProperty<Boolean> HAS_ACCENT_COLOR = new ModelProperty();
    private static final ModelProperty<List<RenderInfo.DisplayItem>> DISPLAY_ITEMS = new ModelProperty();
    private static final ModelProperty<List<Integer>> INACCESSIBLE_SLOTS = new ModelProperty();
    private static final ModelProperty<Map<BarrelMaterial, ResourceLocation>> MATERIALS = new ModelProperty();
    public static final Cache<Integer, List<BakedQuad>> BAKED_QUADS_CACHE = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build();
    private static final Map<Integer, IQuadTransformer> DISPLAY_ROTATIONS = new HashMap<Integer, IQuadTransformer>();
    private static final Vector3f DEFAULT_ROTATION = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final ItemTransforms ITEM_TRANSFORMS = BarrelBakedModelBase.createItemTransforms();
    private static final List<BarrelMaterial> PARTICLE_ICON_MATERIAL_PRIORITY = List.of(BarrelMaterial.ALL, BarrelMaterial.ALL_BUT_TRIM, BarrelMaterial.TOP_ALL, BarrelMaterial.TOP);
    private final ModelBaker baker;
    protected final Map<String, Map<BarrelModelPart, BakedModel>> woodModelParts;
    private final ItemOverrides barrelItemOverrides;
    private Item barrelItem = Items.f_41852_;
    @Nullable
    private String barrelWoodName = null;
    private boolean barrelHasMainColor = false;
    private boolean barrelHasAccentColor = false;
    private boolean barrelIsPacked = false;
    private boolean barrelShowsTier = true;
    private Map<BarrelMaterial, ResourceLocation> barrelMaterials = new EnumMap<BarrelMaterial, ResourceLocation>(BarrelMaterial.class);
    private boolean flatTop = false;
    private final Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData;
    private final Map<String, Map<BarrelModelPart, BakedModel>> woodPartitionedModelParts;
    private final Cache<Integer, BakedModel> dynamicBakedModelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    private static ItemTransforms createItemTransforms() {
        return new ItemTransforms(new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.15625f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.890625f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.1875f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f), DEFAULT_ROTATION), new ItemTransform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.5f), DEFAULT_ROTATION), ImmutableMap.of());
    }

    public static void invalidateCache() {
        DIRECTION_MOVES_3D_ITEMS.invalidateAll();
        DIRECTION_MOVE_BACK_TO_SIDE.invalidateAll();
        BAKED_QUADS_CACHE.invalidateAll();
    }

    protected BarrelBakedModelBase(ModelBaker baker, Map<String, Map<BarrelModelPart, BakedModel>> woodModelParts, @Nullable BakedModel flatTopModel, Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData, Map<String, Map<BarrelModelPart, BakedModel>> woodPartitionedModelParts) {
        this.baker = baker;
        this.woodModelParts = woodModelParts;
        this.barrelItemOverrides = new BarrelItemOverrides(this, flatTopModel);
        this.woodDynamicBakingData = woodDynamicBakingData;
        this.woodPartitionedModelParts = woodPartitionedModelParts;
    }

    private static IQuadTransformer getDirectionRotationTransform(Direction dir) {
        return QuadTransformers.applying((Transformation)new Transformation(null, DisplayItemRenderer.getNorthBasedRotation(dir), null, null));
    }

    private IQuadTransformer getDirectionMoveBackToSide(BlockState state, Direction dir, float distFromCenter, int displayItemIndex, int displayItemCount) {
        int hash = this.calculateMoveBackToSideHash(state, dir, distFromCenter, displayItemIndex, displayItemCount);
        IQuadTransformer transform = (IQuadTransformer)DIRECTION_MOVE_BACK_TO_SIDE.getIfPresent((Object)hash);
        if (transform == null) {
            Vec3i normal = dir.m_122436_();
            Vector3f offset = new Vector3f(distFromCenter, distFromCenter, distFromCenter);
            offset.mul((float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_());
            Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, displayItemCount);
            frontOffset.add(-0.5f, -0.5f, -0.5f);
            this.rotateDisplayItemFrontOffset(state, dir, frontOffset);
            frontOffset.add(0.5f, 0.5f, 0.5f);
            offset.add((Vector3fc)frontOffset);
            transform = QuadTransformers.applying((Transformation)new Transformation(offset, null, null, null));
            DIRECTION_MOVE_BACK_TO_SIDE.put((Object)hash, (Object)transform);
        }
        return transform;
    }

    protected void rotateDisplayItemFrontOffset(BlockState state, Direction dir, Vector3f frontOffset) {
        frontOffset.rotate((Quaternionfc)DisplayItemRenderer.getNorthBasedRotation(dir));
    }

    protected int calculateMoveBackToSideHash(BlockState state, Direction dir, float distFromCenter, int displayItemIndex, int displayItemCount) {
        int hash = Float.hashCode(distFromCenter);
        hash = 31 * hash + displayItemIndex;
        hash = 31 * hash + displayItemCount;
        return hash;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_(), RenderType.m_110466_()});
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        boolean showsTier;
        Map<BarrelMaterial, ResourceLocation> materials;
        boolean isPacked;
        boolean hasAccentColor;
        boolean hasMainColor;
        int hash = this.createHash(state, side, extraData, renderType);
        List quads = (List)BAKED_QUADS_CACHE.getIfPresent((Object)hash);
        if (quads != null) {
            return quads;
        }
        String woodName = null;
        if (state != null) {
            hasMainColor = Boolean.TRUE.equals(extraData.get(HAS_MAIN_COLOR));
            hasAccentColor = Boolean.TRUE.equals(extraData.get(HAS_ACCENT_COLOR));
            if (extraData.has(WOOD_NAME)) {
                woodName = (String)extraData.get(WOOD_NAME);
            }
            isPacked = this.isPacked(extraData);
            materials = this.getMaterials(extraData);
            showsTier = this.showsTier(extraData);
        } else {
            woodName = this.barrelWoodName;
            hasMainColor = this.barrelHasMainColor;
            hasAccentColor = this.barrelHasAccentColor;
            isPacked = this.barrelIsPacked;
            materials = this.barrelMaterials;
            showsTier = this.barrelShowsTier;
        }
        ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
        boolean isBakedDynamically = !materials.isEmpty();
        Set materialModelParts = materials.keySet().stream().map(BarrelMaterial::getMaterialModelPart).collect(Collectors.toSet());
        boolean rendersUsingSplitModel = materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.CORE) || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.TRIM);
        Map<BarrelModelPart, BakedModel> modelParts = this.getWoodModelParts(woodName, isBakedDynamically && rendersUsingSplitModel);
        if (modelParts.isEmpty()) {
            return Collections.emptyList();
        }
        if (!(hasMainColor && hasAccentColor || isBakedDynamically)) {
            this.addPartQuads(state, side, rand, ret, modelParts, this.getBasePart(state), renderType);
        }
        this.addTintableModelQuads(state, side, rand, ret, hasMainColor, hasAccentColor, modelParts, renderType);
        if (isBakedDynamically && (renderType == null || renderType == RenderType.m_110463_())) {
            this.bakeAndAddDynamicQuads(BarrelBakedModelBase.getSpriteSide(state, side), rand, woodName, materials, rendersUsingSplitModel, !hasMainColor || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.CORE), !hasAccentColor || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.TRIM)).forEach(bakedModel -> ret.addAll(bakedModel.getQuads(state, side, rand, ModelData.EMPTY, renderType)));
        }
        if (showsTier) {
            this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.TIER, renderType);
        }
        if (isPacked) {
            this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.PACKED, renderType);
        } else {
            if (this.showsLocked(extraData)) {
                this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.LOCKED, renderType);
            }
            this.addDisplayItemQuads(state, side, rand, ret, extraData, renderType);
        }
        BAKED_QUADS_CACHE.put((Object)hash, ret);
        return ret;
    }

    public List<BakedQuad> getTierQuads(BlockState state, RandomSource rand, String woodName, RenderType renderType) {
        return this.getPartQuads(state, rand, woodName, BarrelModelPart.TIER, renderType);
    }

    public List<BakedQuad> getLockQuads(BlockState state, RandomSource rand, String woodName, RenderType renderType) {
        return this.getPartQuads(state, rand, woodName, BarrelModelPart.LOCKED, renderType);
    }

    private List<BakedQuad> getPartQuads(BlockState state, RandomSource rand, String woodName, BarrelModelPart part, RenderType renderType) {
        ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
        Map<BarrelModelPart, BakedModel> modelParts = this.getWoodModelParts(woodName, false);
        for (Direction dir : Direction.values()) {
            this.addPartQuads(state, dir, rand, ret, modelParts, part, renderType);
        }
        return ret;
    }

    private static Direction getSpriteSide(@Nullable BlockState state, @Nullable Direction side) {
        Direction sideBeforeRotation;
        Block block;
        if (side == null) {
            return Direction.NORTH;
        }
        if (state != null && (block = state.m_60734_()) instanceof BarrelBlock) {
            BarrelBlock barrelBlock = (BarrelBlock)block;
            sideBeforeRotation = BlockSide.fromDirection(side, barrelBlock.getHorizontalDirection(state), barrelBlock.getVerticalFacing(state)).toDirection(Direction.NORTH, VerticalFacing.NO);
        } else {
            sideBeforeRotation = BlockSide.fromDirection(side, Direction.NORTH, VerticalFacing.UP).toDirection(Direction.NORTH, VerticalFacing.NO);
        }
        return sideBeforeRotation;
    }

    private List<BakedModel> bakeAndAddDynamicQuads(@Nullable Direction spriteSide, RandomSource rand, @Nullable String woodName, Map<BarrelMaterial, ResourceLocation> barrelMaterials, boolean rendersUsingSplitModel, boolean renderCore, boolean renderTrim) {
        Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData> bakingData = this.woodDynamicBakingData.get(woodName != null ? woodName : WoodType.f_61833_.f_61839_());
        HashMap<String, Either<Material, String>> materials = new HashMap<String, Either<Material, String>>();
        for (Map.Entry<BarrelMaterial, ResourceLocation> entry : barrelMaterials.entrySet()) {
            BarrelMaterial barrelMaterial = entry.getKey();
            ResourceLocation blockName = entry.getValue();
            TextureAtlasSprite sprite = RenderHelper.getSprite(blockName, spriteSide, rand);
            Either material = Either.left((Object)new Material(InventoryMenu.f_39692_, sprite.m_245424_().m_246162_()));
            for (BarrelMaterial childMaterial : barrelMaterial.getChildren()) {
                materials.put(childMaterial.m_7912_(), (Either<Material, String>)material);
            }
        }
        ArrayList<BakedModel> models = new ArrayList<BakedModel>();
        if (rendersUsingSplitModel) {
            if (renderCore) {
                models.add(this.getDynamicModel(woodName, bakingData, materials, DynamicBarrelBakingData.DynamicPart.CORE));
            }
            if (renderTrim) {
                models.add(this.getDynamicModel(woodName, bakingData, materials, DynamicBarrelBakingData.DynamicPart.TRIM));
            }
        } else {
            models.add(this.getDynamicModel(woodName, bakingData, materials, DynamicBarrelBakingData.DynamicPart.WHOLE));
        }
        return models;
    }

    private BakedModel getDynamicModel(@Nullable String woodName, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData> bakingData, Map<String, Either<Material, String>> materials, DynamicBarrelBakingData.DynamicPart dynamicPart) {
        int hash = Objects.hash(woodName, materials, dynamicPart.name());
        BakedModel bakedModel = (BakedModel)this.dynamicBakedModelCache.getIfPresent((Object)hash);
        if (bakedModel == null) {
            bakedModel = this.compileAndBakeModel(materials, bakingData.get((Object)dynamicPart));
            this.dynamicBakedModelCache.put((Object)hash, (Object)bakedModel);
        }
        return bakedModel;
    }

    private BlockState getDefaultBlockState(ResourceLocation blockName) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockName);
        return block != null ? block.m_49966_() : Blocks.f_50016_.m_49966_();
    }

    private Map<BarrelMaterial, ResourceLocation> getMaterials(ModelData extraData) {
        return extraData.has(MATERIALS) ? Objects.requireNonNull((Map)extraData.get(MATERIALS)) : Collections.emptyMap();
    }

    private BakedModel compileAndBakeModel(Map<String, Either<Material, String>> materials, DynamicBarrelBakingData bakingData) {
        bakingData.modelPartDefinition().textures().forEach((textureName, texture) -> {
            if (!materials.containsKey(textureName)) {
                materials.put((String)textureName, (Either<Material, String>)Either.left((Object)texture));
            }
        });
        BarrelDynamicModelBase.BarrelModelPartDefinition baseModelPartDefinition = bakingData.modelPartDefinition();
        return baseModelPartDefinition.modelLocation().map(modelLocation -> {
            CompositeElementsModel baseModel = new CompositeElementsModel((ResourceLocation)modelLocation, materials);
            ModelBakery bakery = Minecraft.m_91087_().m_91304_().getModelBakery();
            baseModel.m_5500_(arg_0 -> ((ModelBakery)bakery).m_119341_(arg_0));
            return baseModel.m_111449_(this.baker, baseModel, this.baker.getModelTextureGetter(), bakingData.modelState(), bakingData.modelLocation(), false);
        }).orElse(Minecraft.m_91087_().m_91304_().m_119409_());
    }

    protected abstract BarrelModelPart getBasePart(@Nullable BlockState var1);

    private boolean isPacked(ModelData extraData) {
        return extraData.has(IS_PACKED) && Boolean.TRUE.equals(extraData.get(IS_PACKED));
    }

    private boolean showsLocked(ModelData extraData) {
        return extraData.has(SHOWS_LOCK) && Boolean.TRUE.equals(extraData.get(SHOWS_LOCK));
    }

    private boolean showsTier(ModelData extraData) {
        return extraData.has(SHOWS_TIER) && Boolean.TRUE.equals(extraData.get(SHOWS_TIER));
    }

    private int createHash(@Nullable BlockState state, @Nullable Direction side, ModelData data, RenderType renderType) {
        int hash = state != null ? this.getInWorldBlockHash(state, data, renderType) : this.getItemBlockHash();
        hash = hash * 31 + (side == null ? 0 : side.m_122411_() + 1);
        hash = this.getDisplayItemsHash(data, hash);
        return hash;
    }

    private int getItemBlockHash() {
        int hash = this.barrelItem.hashCode();
        hash = hash * 31 + (this.barrelWoodName != null ? this.barrelWoodName.hashCode() + 1 : 0);
        hash = hash * 31 + (this.barrelHasMainColor ? 1 : 0);
        hash = hash * 31 + (this.barrelHasAccentColor ? 1 : 0);
        hash = hash * 31 + (this.barrelIsPacked ? 1 : 0);
        hash = hash * 31 + (this.barrelShowsTier ? 1 : 0);
        hash = hash * 31 + (this.flatTop ? 1 : 0);
        hash = hash * 31 + this.barrelMaterials.hashCode();
        return hash;
    }

    protected int getInWorldBlockHash(BlockState state, ModelData data, @Nullable RenderType renderType) {
        int hash = state.m_60734_().hashCode();
        hash = hash * 31 + (renderType == null ? 0 : renderType.hashCode());
        hash = hash * 31 + (data.has(WOOD_NAME) ? ((String)data.get(WOOD_NAME)).hashCode() + 1 : 0);
        hash = hash * 31 + (data.has(HAS_MAIN_COLOR) && Boolean.TRUE.equals(data.get(HAS_MAIN_COLOR)) ? 1 : 0);
        hash = hash * 31 + (data.has(HAS_ACCENT_COLOR) && Boolean.TRUE.equals(data.get(HAS_ACCENT_COLOR)) ? 1 : 0);
        hash = hash * 31 + (this.isPacked(data) ? 1 : 0);
        hash = hash * 31 + (this.showsLocked(data) ? 1 : 0);
        hash = hash * 31 + (this.showsTier(data) ? 1 : 0);
        hash = hash * 31 + (Boolean.TRUE.equals(state.m_61143_((Property)BarrelBlock.FLAT_TOP)) ? 1 : 0);
        hash = hash * 31 + (data.has(MATERIALS) ? ((Map)data.get(MATERIALS)).hashCode() : 0);
        return hash;
    }

    private int getDisplayItemsHash(ModelData data, int hash) {
        if (data.has(DISPLAY_ITEMS)) {
            List displayItems = (List)data.get(DISPLAY_ITEMS);
            for (RenderInfo.DisplayItem displayItem : displayItems) {
                hash = hash * 31 + this.getDisplayItemHash(displayItem);
            }
        }
        if (data.has(INACCESSIBLE_SLOTS)) {
            List inaccessibleSlots = (List)data.get(INACCESSIBLE_SLOTS);
            for (Integer inaccessibleSlot : inaccessibleSlots) {
                hash = hash * 31 + inaccessibleSlot;
            }
        }
        return hash;
    }

    private int getDisplayItemHash(RenderInfo.DisplayItem displayItem) {
        int hash = displayItem.getRotation();
        hash = hash * 31 + ItemStackKey.getHashCode((ItemStack)displayItem.getItem());
        hash = hash * 31 + displayItem.getSlotIndex();
        return hash;
    }

    private void addDisplayItemQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, List<BakedQuad> ret, ModelData data, @Nullable RenderType renderType) {
        Block block;
        if (state == null || side != null || !((block = state.m_60734_()) instanceof BarrelBlock)) {
            return;
        }
        BarrelBlock barrelBlock = (BarrelBlock)block;
        List displayItems = (List)data.get(DISPLAY_ITEMS);
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        if (displayItems != null && !displayItems.isEmpty()) {
            int index = 0;
            for (RenderInfo.DisplayItem displayItem : displayItems) {
                ItemStack item = displayItem.getItem();
                if (barrelBlock.hasFixedIndexDisplayItems()) {
                    index = displayItem.getSlotIndex();
                }
                if (item.m_41619_()) continue;
                BakedModel model = itemRenderer.m_174264_(item, null, (LivingEntity)minecraft.f_91074_, 0);
                if (!model.m_7521_() && BarrelBakedModelBase.shouldRenderForRenderType(item, renderType, model)) {
                    int rotation = displayItem.getRotation();
                    for (Direction face : Direction.values()) {
                        this.addRenderedItemSide(state, rand, ret, item, model, rotation, face, index, barrelBlock.getDisplayItemsCount(displayItems));
                    }
                    this.addRenderedItemSide(state, rand, ret, item, model, rotation, null, index, barrelBlock.getDisplayItemsCount(displayItems));
                }
                ++index;
            }
        }
        this.addInaccessibleSlotsQuads(state, rand, ret, data, barrelBlock, displayItems, minecraft);
    }

    private static boolean shouldRenderForRenderType(ItemStack item, @Nullable RenderType renderType, BakedModel model) {
        BlockItem blockItem;
        ChunkRenderTypeSet renderTypes;
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        if (renderType == null || clientLevel == null) {
            return true;
        }
        Item item2 = item.m_41720_();
        if (item2 instanceof BlockItem && (renderTypes = model.getRenderTypes((blockItem = (BlockItem)item2).m_40614_().m_49966_(), clientLevel.m_213780_(), ModelData.EMPTY)).contains(RenderType.m_110466_())) {
            return renderType == RenderType.m_110466_() || renderTypes.asList().size() > 1;
        }
        return renderType != RenderType.m_110466_();
    }

    private void addInaccessibleSlotsQuads(BlockState state, RandomSource rand, List<BakedQuad> ret, ModelData data, BarrelBlock barrelBlock, @Nullable List<RenderInfo.DisplayItem> displayItems, Minecraft minecraft) {
        List inaccessibleSlots = (List)data.get(INACCESSIBLE_SLOTS);
        if (displayItems != null && inaccessibleSlots != null) {
            ItemStack inaccessibleSlotStack = new ItemStack((ItemLike)ModItems.INACCESSIBLE_SLOT.get());
            BakedModel model = minecraft.m_91291_().m_174264_(inaccessibleSlotStack, null, (LivingEntity)minecraft.f_91074_, 0);
            Iterator iterator = inaccessibleSlots.iterator();
            while (iterator.hasNext()) {
                int inaccessibleSlot = (Integer)iterator.next();
                if (model.m_7521_()) continue;
                for (Direction face : Direction.values()) {
                    this.addRenderedItemSide(state, rand, ret, inaccessibleSlotStack, model, 0, face, inaccessibleSlot, barrelBlock.getDisplayItemsCount(displayItems));
                }
                this.addRenderedItemSide(state, rand, ret, inaccessibleSlotStack, model, 0, null, inaccessibleSlot, barrelBlock.getDisplayItemsCount(displayItems));
            }
        }
    }

    private void addRenderedItemSide(BlockState state, RandomSource rand, List<BakedQuad> ret, ItemStack displayItem, BakedModel model, int rotation, @Nullable Direction dir, int displayItemIndex, int displayItemCount) {
        Direction direction;
        Block block;
        List quads = model.m_213637_(null, dir, rand);
        quads = MOVE_TO_CORNER.process(quads);
        quads = QuadTransformers.applying((Transformation)this.toTransformation(model.m_7442_().m_269404_(ItemDisplayContext.FIXED))).process(quads);
        if (!model.m_7539_()) {
            quads = displayItemCount == 1 ? SCALE_BIG_2D_ITEM.process(quads) : SCALE_SMALL_2D_ITEM.process(quads);
        } else if (displayItemCount > 1) {
            quads = SCALE_SMALL_3D_ITEM.process(quads);
        }
        if (rotation != 0) {
            quads = this.getDisplayRotation(rotation).process(quads);
        }
        if ((block = state.m_60734_()) instanceof BarrelBlock) {
            BarrelBlock barrelBlock = (BarrelBlock)block;
            direction = barrelBlock.getFacing(state);
        } else {
            direction = Direction.NORTH;
        }
        Direction facing = direction;
        quads = this.rotateDisplayItemQuads(quads, state);
        if (model.m_7539_()) {
            IQuadTransformer transformer = this.getDirectionMove(displayItem, model, state, facing, displayItemIndex, displayItemCount, displayItemCount == 1 ? 1.0f : 0.5f);
            quads = transformer.process(quads);
            this.recalculateDirections(quads);
        } else {
            quads = this.getDirectionMove(displayItem, model, state, facing, displayItemIndex, displayItemCount, 1.0f).process(quads);
            this.recalculateDirections(quads);
        }
        this.updateTintIndexes(quads, displayItemIndex);
        ret.addAll(quads);
    }

    private Transformation toTransformation(ItemTransform transform) {
        if (transform.equals((Object)ItemTransform.f_111754_)) {
            return Transformation.m_121093_();
        }
        return new Transformation(transform.f_111756_, this.quatFromXYZ(transform.f_111755_, true), transform.f_111757_, null);
    }

    public Quaternionf quatFromXYZ(Vector3f xyz, boolean degrees) {
        return TransformationHelper.quatFromXYZ((float)xyz.x(), (float)xyz.y(), (float)xyz.z(), (boolean)degrees);
    }

    protected abstract List<BakedQuad> rotateDisplayItemQuads(List<BakedQuad> var1, BlockState var2);

    private void updateTintIndexes(List<BakedQuad> quads, int displayItemIndex) {
        int offset = (displayItemIndex + 1) * 10;
        quads.forEach(quad -> {
            if (quad.f_111293_ >= 0) {
                quad.f_111293_ += offset;
            }
        });
    }

    private void recalculateDirections(List<BakedQuad> quads) {
        quads.forEach(quad -> {
            quad.f_111294_ = FaceBakery.m_111612_((int[])quad.m_111303_());
        });
    }

    private IQuadTransformer getDirectionMove(ItemStack displayItem, BakedModel model, BlockState state, Direction direction, int displayItemIndex, int displayItemCount, float itemScale) {
        boolean isFlatTop = (Boolean)state.m_61143_((Property)BarrelBlock.FLAT_TOP);
        int hash = this.calculateDirectionMoveHash(state, displayItem, displayItemIndex, displayItemCount, isFlatTop);
        Cache directionCache = (Cache)DIRECTION_MOVES_3D_ITEMS.getUnchecked((Object)direction);
        IQuadTransformer transformer = (IQuadTransformer)directionCache.getIfPresent((Object)hash);
        if (transformer == null) {
            double offset = DisplayItemRenderer.getDisplayItemOffset(displayItem, model, itemScale);
            if (!isFlatTop) {
                offset -= 0.0625;
            }
            transformer = this.getDirectionMoveBackToSide(state, direction, (float)(0.5 + offset), displayItemIndex, displayItemCount);
            directionCache.put((Object)hash, (Object)transformer);
        }
        return transformer;
    }

    protected int calculateDirectionMoveHash(BlockState state, ItemStack displayItem, int displayItemIndex, int displayItemCount, boolean isFlatTop) {
        int hashCode = ItemStackKey.getHashCode((ItemStack)displayItem);
        hashCode = hashCode * 31 + displayItemIndex;
        hashCode = hashCode * 31 + displayItemCount;
        hashCode = hashCode * 31 + (isFlatTop ? 1 : 0);
        return hashCode;
    }

    private IQuadTransformer getDisplayRotation(int rotation) {
        return DISPLAY_ROTATIONS.computeIfAbsent(rotation, r -> QuadTransformers.applying((Transformation)new Transformation(null, Axis.f_252403_.m_252977_((float)rotation), null, null)));
    }

    private void addTintableModelQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, List<BakedQuad> ret, boolean hasMainColor, boolean hasAccentColor, Map<BarrelModelPart, BakedModel> modelParts, @Nullable RenderType renderType) {
        if (renderType != null && renderType != RenderType.m_110463_()) {
            return;
        }
        if (hasAccentColor) {
            this.addPartQuads(state, side, rand, ret, modelParts, BarrelModelPart.TINTABLE_ACCENT, renderType);
        }
        if (hasMainColor) {
            this.addPartQuads(state, side, rand, ret, modelParts, this.getMainPart(state), renderType);
        }
    }

    private BarrelModelPart getMainPart(@Nullable BlockState state) {
        return this.rendersOpen() && state != null && Boolean.TRUE.equals(state.m_61143_((Property)BarrelBlock.OPEN)) ? BarrelModelPart.TINTABLE_MAIN_OPEN : BarrelModelPart.TINTABLE_MAIN;
    }

    protected abstract boolean rendersOpen();

    private void addPartQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, List<BakedQuad> ret, Map<BarrelModelPart, BakedModel> modelParts, BarrelModelPart part, @Nullable RenderType renderType) {
        if (renderType != null && renderType != RenderType.m_110463_()) {
            return;
        }
        if (modelParts.containsKey((Object)part)) {
            ret.addAll(modelParts.getOrDefault((Object)part, Minecraft.m_91087_().m_91304_().m_119409_()).getQuads(state, side, rand, ModelData.EMPTY, renderType));
        }
    }

    private Map<BarrelModelPart, BakedModel> getWoodModelParts(@Nullable String barrelWoodName, boolean requiresPartitionedModel) {
        if (requiresPartitionedModel && this.woodPartitionedModelParts.containsKey(barrelWoodName)) {
            return this.woodPartitionedModelParts.get(barrelWoodName);
        }
        if (this.woodModelParts.isEmpty()) {
            return Collections.emptyMap();
        }
        if (barrelWoodName == null || !this.woodModelParts.containsKey(barrelWoodName)) {
            return this.woodModelParts.values().iterator().next();
        }
        return this.woodModelParts.get(barrelWoodName);
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.getWoodModelParts(null, false).getOrDefault((Object)BarrelModelPart.BASE, Minecraft.m_91087_().m_91304_().m_119409_()).m_6160_();
    }

    public ItemTransforms m_7442_() {
        return ITEM_TRANSFORMS;
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        Map materials;
        if (data.has(HAS_MAIN_COLOR) && Boolean.TRUE.equals(data.get(HAS_MAIN_COLOR))) {
            return this.getWoodModelParts(null, false).get((Object)BarrelModelPart.TINTABLE_MAIN).getParticleIcon(data);
        }
        if (data.has(MATERIALS) && (materials = (Map)data.get(MATERIALS)) != null) {
            for (BarrelMaterial barrelMaterial : PARTICLE_ICON_MATERIAL_PRIORITY) {
                if (!materials.containsKey((Object)barrelMaterial)) continue;
                BlockState blockState = this.getDefaultBlockState((ResourceLocation)materials.get((Object)barrelMaterial));
                return Minecraft.m_91087_().m_91289_().m_110910_(blockState).getParticleIcon(ModelData.EMPTY);
            }
        }
        if (data.has(WOOD_NAME)) {
            String name = (String)data.get(WOOD_NAME);
            if (!this.woodModelParts.containsKey(name)) {
                return this.m_6160_();
            }
            return this.getWoodModelParts(name, false).get((Object)BarrelModelPart.BASE).getParticleIcon(data);
        }
        return this.m_6160_();
    }

    @Nonnull
    public ModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData tileData) {
        return WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, BarrelBlockEntity.class).map(BarrelBakedModelBase::getModelDataFromBlockEntity).orElse(ModelData.EMPTY);
    }

    public static ModelData getModelDataFromBlockEntity(BarrelBlockEntity be) {
        Map<BarrelMaterial, ResourceLocation> materials;
        ModelData.Builder builder = ModelData.builder();
        boolean hasMainColor = be.getStorageWrapper().hasMainColor();
        builder.with(HAS_MAIN_COLOR, (Object)hasMainColor);
        boolean hasAccentColor = be.getStorageWrapper().hasAccentColor();
        builder.with(HAS_ACCENT_COLOR, (Object)hasAccentColor);
        if (!be.hasFullyDynamicRenderer()) {
            builder.with(DISPLAY_ITEMS, (Object)be.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getDisplayItems());
            builder.with(INACCESSIBLE_SLOTS, (Object)be.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getInaccessibleSlots());
        }
        builder.with(IS_PACKED, (Object)be.isPacked());
        builder.with(SHOWS_LOCK, (Object)(be.isLocked() && be.shouldShowLock() ? 1 : 0));
        builder.with(SHOWS_TIER, (Object)be.shouldShowTier());
        Optional<WoodType> woodType = be.getWoodType();
        if (woodType.isPresent() || !hasMainColor || !hasAccentColor) {
            builder.with(WOOD_NAME, (Object)woodType.orElse(WoodType.f_61833_).f_61839_());
        }
        if (!(materials = be.getMaterials()).isEmpty()) {
            builder.with(MATERIALS, materials);
        }
        return builder.build();
    }

    public ItemOverrides m_7343_() {
        return this.barrelItemOverrides;
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        if (transformType == ItemDisplayContext.NONE) {
            return this;
        }
        ITEM_TRANSFORMS.m_269404_(transformType).m_111763_(applyLeftHandTransform, poseStack);
        return this;
    }

    private static class BarrelItemOverrides
    extends ItemOverrides {
        private final BarrelBakedModelBase barrelBakedModel;
        @Nullable
        private final BakedModel flatTopModel;
        private Cache<Integer, BakedModel> resolvedModels = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

        public BarrelItemOverrides(BarrelBakedModelBase barrelBakedModel, @Nullable BakedModel flatTopModel) {
            this.barrelBakedModel = barrelBakedModel;
            this.flatTopModel = flatTopModel;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            boolean flatTop = BarrelBlockItem.isFlatTop(stack);
            if (this.flatTopModel != null && flatTop) {
                return this.flatTopModel.m_7343_().m_173464_(this.flatTopModel, stack, level, entity, seed);
            }
            boolean hasMainColor = StorageBlockItem.getMainColorFromStack(stack).isPresent();
            boolean hasAccentColor = StorageBlockItem.getAccentColorFromStack(stack).isPresent();
            Map<BarrelMaterial, ResourceLocation> materials = BarrelBlockItem.getMaterials(stack);
            String woodName = WoodStorageBlockItem.getWoodType(stack).map(WoodType::f_61839_).orElse((String)(this.barrelBakedModel.barrelHasAccentColor && this.barrelBakedModel.barrelHasMainColor && materials.isEmpty() ? null : WoodType.f_61833_.f_61839_()));
            boolean packed = WoodStorageBlockItem.isPacked(stack);
            boolean barrelShowsTier = StorageBlockItem.showsTier(stack);
            Item item = stack.m_41720_();
            int hash = Objects.hash(item, woodName, hasMainColor, hasAccentColor, packed, barrelShowsTier, flatTop, materials);
            Object resolvedModel = (BakedModel)this.resolvedModels.getIfPresent((Object)hash);
            if (resolvedModel == null) {
                resolvedModel = new ResolvedModel(hasMainColor, hasAccentColor, woodName, packed, barrelShowsTier, materials, flatTop, item);
                this.resolvedModels.put((Object)hash, resolvedModel);
            }
            return resolvedModel;
        }

        private class ResolvedModel
        extends BakedModelWrapper<BarrelBakedModelBase> {
            private final boolean hasMainColor;
            private final boolean hasAccentColor;
            @Nullable
            private final String woodName;
            private final boolean packed;
            private final boolean barrelShowsTier;
            private final Map<BarrelMaterial, ResourceLocation> materials;
            private final boolean flatTop;
            private final Item item;

            public ResolvedModel(boolean hasMainColor, @Nullable boolean hasAccentColor, String woodName, boolean packed, boolean barrelShowsTier, Map<BarrelMaterial, ResourceLocation> materials, boolean flatTop, Item item) {
                super((BakedModel)BarrelItemOverrides.this.barrelBakedModel);
                this.hasMainColor = hasMainColor;
                this.hasAccentColor = hasAccentColor;
                this.woodName = woodName;
                this.packed = packed;
                this.barrelShowsTier = barrelShowsTier;
                this.materials = materials;
                this.flatTop = flatTop;
                this.item = item;
            }

            public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
                this.setProperties();
                return super.m_213637_(state, side, rand);
            }

            public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
                this.setProperties();
                return super.getQuads(state, side, rand, extraData, renderType);
            }

            public BakedModel applyTransform(ItemDisplayContext cameraTransformType, PoseStack poseStack, boolean applyLeftHandTransform) {
                super.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
                return this;
            }

            public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
                return List.of(this);
            }

            private void setProperties() {
                BarrelItemOverrides.this.barrelBakedModel.barrelHasMainColor = this.hasMainColor;
                BarrelItemOverrides.this.barrelBakedModel.barrelHasAccentColor = this.hasAccentColor;
                BarrelItemOverrides.this.barrelBakedModel.barrelWoodName = this.woodName;
                BarrelItemOverrides.this.barrelBakedModel.barrelIsPacked = this.packed;
                BarrelItemOverrides.this.barrelBakedModel.barrelShowsTier = this.barrelShowsTier;
                BarrelItemOverrides.this.barrelBakedModel.barrelMaterials = this.materials;
                BarrelItemOverrides.this.barrelBakedModel.flatTop = this.flatTop;
                BarrelItemOverrides.this.barrelBakedModel.barrelItem = this.item;
            }
        }
    }
}

