/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.fluid_generators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.ordana.immersive_weathering.data.fluid_generators.ModFluidGenerators;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public interface IFluidGenerator
extends Comparable<IFluidGenerator> {
    public static final Codec<IFluidGenerator> CODEC = Type.CODEC.dispatch("type", IFluidGenerator::getType, Type::codec);

    public Optional<BlockPos> tryGenerating(List<Direction> var1, BlockPos var2, Level var3, Map<Direction, BlockState> var4);

    public Fluid getFluid();

    public FluidType getFluidType();

    public Type<?> getType();

    public int getPriority();

    default public SoundEvent getSound() {
        return null;
    }

    @Override
    default public int compareTo(@NotNull IFluidGenerator o) {
        return Integer.compare(this.getPriority(), o.getPriority());
    }

    public record Type<T extends IFluidGenerator>(Codec<T> codec, String name) {
        private static final Codec<Type<?>> CODEC = Codec.STRING.flatXmap(name -> ModFluidGenerators.get(name).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown Fluid Generator type: " + name)), t -> DataResult.success((Object)t.name()));
    }

    public static enum FluidType implements StringRepresentable
    {
        BOTH("both"),
        FLOWING("flowing"),
        STILL("still");

        public static final Codec<FluidType> CODEC;
        private final String name;

        private FluidType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        public boolean isStill() {
            return this != FLOWING;
        }

        public boolean isFlowing() {
            return this != STILL;
        }

        static {
            CODEC = StringRepresentable.m_216439_(FluidType::values);
        }
    }
}

