/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.dynamicpack;

import com.mojang.blaze3d.platform.NativeImage;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModItems;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.Logger;

public class ClientDynamicResourcesHandler
extends DynClientResourcesGenerator {
    public static final ClientDynamicResourcesHandler INSTANCE = new ClientDynamicResourcesHandler();
    public static final Predicate<String> LOOKS_LIKE_LEAF_TEXTURE = s -> !(s = new ResourceLocation(s).m_135815_()).contains("_bushy") && !s.contains("_snow") && !s.contains("_overlay");

    public ClientDynamicResourcesHandler() {
        super(new DynamicTexturePack(ImmersiveWeathering.res("generated_pack")));
        ((DynamicTexturePack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || CommonConfigs.DEBUG_RESOURCES.get() != false);
    }

    public Logger getLogger() {
        return ImmersiveWeathering.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void addLeafPilesModel(StaticResource resource, String id, ResourceLocation texturePath) {
        String string = new String(resource.data, StandardCharsets.UTF_8);
        String path = resource.location.m_135815_().replace("oak_leaf_pile", id);
        string = string.replace("immersive_weathering:block/light_oak_leaves", texturePath.toString());
        string = string.replace("immersive_weathering:block/medium_oak_leaves", texturePath.toString());
        string = string.replace("heavy_oak_leaves", id.replace("/", "/heavy_"));
        ResourceLocation newRes = ImmersiveWeathering.res(path);
        ((DynamicTexturePack)this.dynamicPack).addBytes(newRes, string.getBytes(), ResType.GENERIC);
    }

    public void regenerateDynamicAssets(ResourceManager manager) {
        StaticResource lpBlockState = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(ImmersiveWeathering.res("oak_leaf_pile")));
        StaticResource lpModel1 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height1")));
        StaticResource lpModel2 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height2")));
        StaticResource lpModel4 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height4")));
        StaticResource lpModel6 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height6")));
        StaticResource lpModel8 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height8")));
        StaticResource lpModel10 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height10")));
        StaticResource lpModel12 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height12")));
        StaticResource lpModel14 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height14")));
        StaticResource lpModel16 = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(ImmersiveWeathering.res("leaf_piles/oak_leaf_pile_height16")));
        StaticResource lpItemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(ImmersiveWeathering.res("oak_leaf_pile")));
        ModBlocks.LEAF_PILES.forEach((leafType, pile) -> {
            if (leafType.isVanilla() && PlatHelper.isDev()) {
                return;
            }
            String path = leafType.getNamespace() + "/" + leafType.getTypeName();
            String id = path + "_leaf_pile";
            try {
                this.addSimilarJsonResource(manager, lpBlockState, "oak_leaf_pile", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Pile blockstate definition for {} : {}", (Object)pile, (Object)ex);
            }
            try {
                this.addSimilarJsonResource(manager, lpItemModel, "oak_leaf_pile", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Pile item model for {} : {}", (Object)pile, (Object)ex);
            }
            try {
                ResourceLocation leavesTexture;
                try {
                    leavesTexture = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)leafType.leaves, LOOKS_LIKE_LEAF_TEXTURE);
                }
                catch (Exception exception) {
                    this.getLogger().warn("Failed to find texture for Leaf Pile {}, using oak one instead", (Object)pile);
                    leavesTexture = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)Blocks.f_50050_, s -> true);
                }
                this.addLeafPilesModel(Objects.requireNonNull(lpModel1), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel2), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel4), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel6), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel8), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel10), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel12), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel14), id, leavesTexture);
                this.addLeafPilesModel(Objects.requireNonNull(lpModel16), id, leavesTexture);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Pile model for {} : {}", (Object)pile, (Object)ex);
            }
        });
        StaticResource itemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(ImmersiveWeathering.res("oak_bark")));
        ModItems.BARK.forEach((woodType, bark) -> {
            if (!woodType.isVanilla() || !PlatHelper.isDev()) {
                String id = Utils.getID((Item)bark).m_135815_();
                try {
                    this.addSimilarJsonResource(manager, itemModel, "oak_bark", id);
                }
                catch (Exception ex) {
                    this.getLogger().error("Failed to generate Bark item model for {} : {}", bark, (Object)ex);
                }
            }
        });
        ModBlocks.LEAF_PILES.forEach((type, pile) -> {
            if (type.isVanilla() && PlatHelper.isDev()) {
                return;
            }
            String path = type.getNamespace() + "/heavy_" + type.getTypeName() + "_leaf_pile";
            try (TextureImage baseTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)type.leaves, LOOKS_LIKE_LEAF_TEXTURE));){
                ResourceLocation textureRes = ImmersiveWeathering.res(String.format("block/%s", path));
                if (!this.alreadyHasTextureAtLocation(manager, textureRes)) {
                    Palette targetPalette = Palette.fromImage((TextureImage)baseTexture);
                    if (targetPalette.getDarkest().getOccurrence() > 5) {
                        targetPalette.increaseDown();
                    }
                    PaletteColor dark = targetPalette.getDarkest();
                    baseTexture.removeAlpha(dark.value());
                    ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, baseTexture);
                }
            }
            catch (Exception ex) {
                this.getLogger().error("Could not generate heavy leaf pile texture for type {}", type, (Object)ex);
            }
        });
        try (TextureImage template = TextureImage.open((ResourceManager)manager, (ResourceLocation)ImmersiveWeathering.res("item/bark_template"));){
            ModItems.BARK.forEach((type, bark) -> {
                if (type.isVanilla() && PlatHelper.isDev()) {
                    return;
                }
                ResourceLocation textureRes = ImmersiveWeathering.res("item/" + Utils.getID((Item)bark).m_135815_());
                if (!this.alreadyHasTextureAtLocation(manager, textureRes)) {
                    try (TextureImage logTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)type.log, s -> !s.contains("top")));){
                        Palette palette = Palette.fromImage((TextureImage)logTexture);
                        palette.increaseDown();
                        PaletteColor dark = palette.getDarkest();
                        assert (template.imageWidth() <= logTexture.imageWidth() && template.imageHeight() <= logTexture.imageHeight());
                        TextureImage newImage = template.makeCopy();
                        NativeImage logImage = logTexture.getImage();
                        newImage.forEachFrame((i, x, y) -> {
                            NativeImage image = newImage.getImage();
                            int darkBorder = image.m_84985_(x.intValue(), y.intValue());
                            if (darkBorder == -1) {
                                image.m_84988_(x.intValue(), y.intValue(), 0);
                            } else if (FastColor.ABGR32.m_266503_((int)darkBorder) == 0) {
                                image.m_84988_(x.intValue(), y.intValue(), logImage.m_84985_(x.intValue(), y.intValue()));
                            } else {
                                image.m_84988_(x.intValue(), y.intValue(), dark.value());
                            }
                        });
                        ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to find log texture for bark {}", type, (Object)ex);
                    }
                }
            });
        }
        catch (Exception e) {
            this.getLogger().error("Could not generate any Bark texture : ", (Throwable)e);
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        ModItems.BARK.forEach((type, bark) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.immersive_weathering.bark", (BlockType)type, (Item)bark));
        ModBlocks.LEAF_PILES.forEach((type, leaf) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"block.immersive_weathering.leaf_pile", (BlockType)type, (Block)leaf));
    }
}

