/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.features;

import com.mojang.serialization.Codec;
import com.ordana.immersive_weathering.features.IcicleClusterFeatureConfig;
import com.ordana.immersive_weathering.features.IcicleHelper;
import com.ordana.immersive_weathering.reg.ModBlocks;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class IcicleClusterFeature
extends Feature<IcicleClusterFeatureConfig> {
    public IcicleClusterFeature(Codec<IcicleClusterFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<IcicleClusterFeatureConfig> context) {
        WorldGenLevel structureWorldAccess = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        IcicleClusterFeatureConfig icicleClusterFeatureConfig = (IcicleClusterFeatureConfig)context.m_159778_();
        RandomSource random = context.m_225041_();
        if (!IcicleHelper.canGenerate((LevelAccessor)structureWorldAccess, blockPos)) {
            return false;
        }
        int i = icicleClusterFeatureConfig.height.m_214085_(random);
        float f = icicleClusterFeatureConfig.wetness.m_214084_(random);
        float g = icicleClusterFeatureConfig.density.m_214084_(random);
        int j = icicleClusterFeatureConfig.radius.m_214085_(random);
        int k = icicleClusterFeatureConfig.radius.m_214085_(random);
        for (int l = -j; l <= j; ++l) {
            for (int m = -k; m <= k; ++m) {
                double d = this.icicleChance(j, k, l, m, icicleClusterFeatureConfig);
                BlockPos blockPos2 = blockPos.m_7918_(l, 0, m);
                this.generate(structureWorldAccess, random, blockPos2, l, m, f, d, i, g, icicleClusterFeatureConfig);
            }
        }
        return true;
    }

    private void generate(WorldGenLevel level, RandomSource random, BlockPos pos, int localX, int localZ, float wetness, double icicleChance, int height, float density, IcicleClusterFeatureConfig config) {
        Optional optional = Column.m_158175_((LevelSimulatedReader)level, (BlockPos)pos, (int)config.floorToCeilingSearchRange, IcicleHelper::canGenerate, IcicleHelper::canReplaceOrLava);
        if (optional.isPresent()) {
            OptionalInt optionalInt = ((Column)optional.get()).m_142011_();
            OptionalInt optionalInt2 = ((Column)optional.get()).m_142009_();
            if (optionalInt.isPresent() || optionalInt2.isPresent()) {
                int t;
                int n;
                int m;
                int l;
                int k;
                int j;
                boolean bl2;
                Column caveSurface;
                boolean bl;
                boolean bl3 = bl = random.m_188501_() < wetness;
                if (bl && optionalInt2.isPresent() && this.canWaterSpawn(level, pos.m_175288_(optionalInt2.getAsInt()))) {
                    int i = optionalInt2.getAsInt();
                    caveSurface = ((Column)optional.get()).m_158181_(OptionalInt.of(i - 1));
                    level.m_7731_(pos.m_175288_(i), Blocks.f_49990_.m_49966_(), 2);
                } else {
                    caveSurface = (Column)optional.get();
                }
                OptionalInt i = caveSurface.m_142009_();
                boolean bl4 = bl2 = random.m_188500_() < icicleChance;
                if (optionalInt.isPresent() && bl2 && this.isLava((LevelReader)level, pos.m_175288_(optionalInt.getAsInt()))) {
                    j = config.icicleBlockLayerThickness.m_214085_(random);
                    this.placeIceBlocks(level, pos.m_175288_(optionalInt.getAsInt()), j, Direction.UP);
                    k = i.isPresent() ? Math.min(height, optionalInt.getAsInt() - i.getAsInt()) : height;
                    l = this.getHeight(random, localX, localZ, density, k, config);
                } else {
                    l = 0;
                }
                int n2 = k = random.m_188500_() < icicleChance ? 1 : 0;
                if (i.isPresent() && k != 0 && this.isLava((LevelReader)level, pos.m_175288_(i.getAsInt()))) {
                    m = config.icicleBlockLayerThickness.m_214085_(random);
                    this.placeIceBlocks(level, pos.m_175288_(i.getAsInt()), m, Direction.DOWN);
                    j = optionalInt.isPresent() ? Math.max(0, l + Mth.m_216287_((RandomSource)random, (int)(-config.maxStalagmiteStalactiteHeightDiff), (int)config.maxStalagmiteStalactiteHeightDiff)) : this.getHeight(random, localX, localZ, density, height, config);
                } else {
                    j = 0;
                }
                if (optionalInt.isPresent() && i.isPresent() && optionalInt.getAsInt() - l <= i.getAsInt() + j) {
                    n = i.getAsInt();
                    int o = optionalInt.getAsInt();
                    int p = Math.max(o - l, n + 1);
                    int q = Math.min(n + j, o - 1);
                    int r = Mth.m_216287_((RandomSource)random, (int)p, (int)(q + 1));
                    int s = r - 1;
                    m = o - r;
                    t = s - n;
                } else {
                    m = l;
                    t = j;
                }
                int n3 = n = random.m_188499_() && m > 0 && t > 0 && caveSurface.m_142030_().isPresent() && m + t == caveSurface.m_142030_().getAsInt() ? 1 : 0;
                if (optionalInt.isPresent()) {
                    IcicleHelper.generateIcicle((LevelAccessor)level, pos.m_175288_(optionalInt.getAsInt() - 1), Direction.DOWN, m, n != 0);
                }
                if (i.isPresent()) {
                    IcicleHelper.generateIcicle((LevelAccessor)level, pos.m_175288_(i.getAsInt() + 1), Direction.UP, t, n != 0);
                }
            }
        }
    }

    private boolean isLava(LevelReader level, BlockPos pos) {
        return !level.m_8055_(pos).m_60713_(Blocks.f_49991_);
    }

    private int getHeight(RandomSource random, int localX, int localZ, float density, int height, IcicleClusterFeatureConfig config) {
        if (random.m_188501_() > density) {
            return 0;
        }
        int i = Math.abs(localX) + Math.abs(localZ);
        float f = (float)Mth.m_144851_((double)i, (double)0.0, (double)config.maxDistanceFromCenterAffectingHeightBias, (double)((double)height / 2.0), (double)0.0);
        return (int)IcicleClusterFeature.clampedGaussian(random, height, f, config.heightDeviation);
    }

    private boolean canWaterSpawn(WorldGenLevel level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        if (!(blockState.m_60713_(Blocks.f_49990_) || blockState.m_60713_(Blocks.f_50126_) || blockState.m_60713_(ModBlocks.ICICLE.get()))) {
            Direction direction;
            Iterator var4 = Direction.Plane.HORIZONTAL.iterator();
            do {
                if (var4.hasNext()) continue;
                return this.isStoneOrWater((LevelAccessor)level, pos.m_7495_());
            } while (this.isStoneOrWater((LevelAccessor)level, pos.m_121945_(direction = (Direction)var4.next())));
        }
        return false;
    }

    private boolean isStoneOrWater(LevelAccessor level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        return blockState.m_204336_(BlockTags.f_13061_) || blockState.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    private void placeIceBlocks(WorldGenLevel level, BlockPos pos, int height, Direction direction) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (int i = 0; i < height; ++i) {
            if (!IcicleHelper.generateIceBlock((LevelAccessor)level, (BlockPos)mutable)) {
                return;
            }
            mutable.m_122173_(direction);
        }
    }

    private double icicleChance(int radiusX, int radiusZ, int localX, int localZ, IcicleClusterFeatureConfig config) {
        int i = radiusX - Math.abs(localX);
        int j = radiusZ - Math.abs(localZ);
        int k = Math.min(i, j);
        return Mth.m_184631_((float)k, (float)0.0f, (float)config.maxDistanceFromCenterAffectingChanceOfIcicleColumn, (float)config.chanceOfIcicleColumnAtMaxDistanceFromCenter, (float)1.0f);
    }

    private static float clampedGaussian(RandomSource random, float max, float mean, float deviation) {
        return ClampedNormalFloat.m_216837_((RandomSource)random, (float)mean, (float)deviation, (float)0.0f, (float)max);
    }
}

