/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.forge;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.events.ModEvents;
import com.ordana.immersive_weathering.forge.CeilingAndWallBlockItem;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModWaxables;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="immersive_weathering")
public class ImmersiveWeatheringForge {
    public static final String MOD_ID = "immersive_weathering";

    public ImmersiveWeatheringForge() {
        ImmersiveWeathering.commonInit();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerOverrides);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerOverrides(RegisterEvent event) {
        if (event.getRegistryKey() == ForgeRegistries.ITEMS.getRegistryKey()) {
            event.getForgeRegistry().register(new ResourceLocation("minecraft:hanging_roots"), (Object)new CeilingAndWallBlockItem(Blocks.f_152548_, ModBlocks.HANGING_ROOTS_WALL.get(), new Item.Properties()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult ret = ModEvents.onBlockCLicked(event.getItemStack(), event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
        if (ret != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(ret);
        }
    }

    private static void registerWaxables() {
        try {
            BiMap oldWaxables = (BiMap)HoneycombItem.f_150863_.get();
            HoneycombItem.f_150863_ = Suppliers.memoize(() -> ImmutableBiMap.builder().putAll((Map)oldWaxables).putAll(ModWaxables.getValues()).build());
            HoneycombItem.f_150864_ = Suppliers.memoize(() -> ((BiMap)HoneycombItem.f_150863_.get()).inverse());
        }
        catch (Exception e) {
            ImmersiveWeathering.LOGGER.error("Failed to register Waxables: ", (Throwable)e);
        }
    }
}

