/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.pipes;

import earth.terrarium.adastra.common.blockentities.base.TickableBlockEntity;
import earth.terrarium.adastra.common.blockentities.pipes.Pipe;
import earth.terrarium.adastra.common.blocks.base.BasicEntityBlock;
import earth.terrarium.adastra.common.blocks.pipes.PipeBlock;
import earth.terrarium.adastra.common.config.MachineConfig;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class PipeBlockEntity
extends BlockEntity
implements TickableBlockEntity,
Pipe {
    protected final Map<BlockPos, Direction> sources = new IdentityHashMap<BlockPos, Direction>();
    protected final Map<BlockPos, Direction> consumers = new IdentityHashMap<BlockPos, Direction>();
    private final long transferRate;
    @Nullable
    private Direction[] connectedDirections;
    private boolean initialized;
    private boolean isController;

    public PipeBlockEntity(BlockPos pos, BlockState state) {
        super(((BasicEntityBlock)state.m_60734_()).entity(state), pos, state);
        PipeBlock pipe = (PipeBlock)state.m_60734_();
        this.transferRate = pipe.transferRate();
    }

    @Override
    public void serverTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        if (this.isController) {
            if (time % (long)MachineConfig.pipeRefreshRate == 0L) {
                this.sources.clear();
                this.consumers.clear();
                this.findNodes(level, pos);
            }
            if (!this.consumers.isEmpty() && !this.sources.isEmpty()) {
                this.transfer(level, this.transferRate, this.sources, this.consumers);
            }
        }
    }

    public void pipeChanged(Level level, BlockPos pos) {
        Direction[] directions = PipeBlock.getConnectedDirections(level.m_8055_(pos));
        this.connectedDirections = directions;
        for (Direction direction : directions) {
            if (level.m_8055_(pos.m_121945_(direction)).m_60734_() instanceof PipeBlock) continue;
            this.isController = true;
            return;
        }
        this.isController = false;
    }

    @Override
    public void firstTick(Level level, BlockPos pos, BlockState state) {
        this.initialized = true;
        this.pipeChanged(level, pos);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Nullable
    public Direction[] connectedDirections() {
        return this.connectedDirections;
    }
}

