/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.items;

import dev.architectury.injectables.annotations.PlatformOnly;
import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.registry.ModFluids;
import earth.terrarium.adastra.common.tags.ModFluidTags;
import earth.terrarium.adastra.common.utils.FluidUtils;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidItem;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedItemFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipGunItem
extends Item
implements BotariumFluidItem<WrappedItemFluidContainer> {
    public ZipGunItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (FluidUtils.hasFluid(stack) || player.m_7500_()) {
            player.m_6672_(usedHand);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity entity, @NotNull ItemStack stack, int remainingUseDuration) {
        super.m_5929_(level, entity, stack, remainingUseDuration);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack mainHandItem = entity.m_21205_();
        ItemStack offhandItem = entity.m_21206_();
        long fuelUsage = 1L;
        boolean mainHandBoost = this.consumeFuel(player, mainHandItem, fuelUsage);
        boolean offHandBoost = this.consumeFuel(player, offhandItem, fuelUsage);
        if (!(mainHandBoost || offHandBoost || player.m_7500_())) {
            player.m_5810_();
            return;
        }
        double maxSpeed = 0.35;
        double particleSpeed = 1.5;
        double propelForce = 0.2;
        double propelYForce = 0.2;
        int particleChance = 4;
        if (GravityApi.API.getGravity((Entity)player) <= 0.05f) {
            propelForce *= 0.1;
            propelYForce *= 0.1;
            maxSpeed *= 20.0;
            entity.f_19789_ *= 0.9f;
        } else {
            propelYForce *= 0.2;
            propelYForce *= 1.0 - Math.min(1.0, entity.m_20186_() / 90.0);
        }
        if (mainHandBoost && offHandBoost) {
            propelForce *= 1.4;
            propelYForce *= 1.25;
            maxSpeed *= 1.5;
            particleSpeed *= 1.5;
            entity.f_19789_ *= 0.9f;
            particleChance -= 2;
        }
        Vec3 lookAngle = entity.m_20154_();
        if (entity.m_20184_().m_82553_() < maxSpeed) {
            Vec3 propelRot = lookAngle.m_82542_(propelForce, propelYForce, propelForce);
            entity.m_246865_(propelRot);
        }
        if (level.f_46441_.m_188503_(particleChance) == 0) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), lookAngle.f_82479_ * particleSpeed + level.f_46441_.m_188583_() * 0.03, lookAngle.f_82480_ * particleSpeed + level.f_46441_.m_188583_() * 0.03, lookAngle.f_82481_ * particleSpeed + level.f_46441_.m_188583_() * 0.03);
        }
    }

    public boolean consumeFuel(Player player, ItemStack stack, long amount) {
        if (!(stack.m_41720_() instanceof ZipGunItem)) {
            return false;
        }
        if (player.m_7500_()) {
            return true;
        }
        ItemStackHolder holder = new ItemStackHolder(stack);
        ItemFluidContainer container = FluidContainer.of((ItemStackHolder)holder);
        if (container == null) {
            return false;
        }
        FluidHolder extracted = container.extractFluid(FluidHolder.ofMillibuckets((Fluid)container.getFirstFluid().getFluid(), (long)FluidConstants.fromMillibuckets((long)amount)), false);
        stack.m_41751_(holder.getStack().m_41783_());
        return extracted.getFluidAmount() > 0L;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    public WrappedItemFluidContainer getFluidContainer(ItemStack holder) {
        return new WrappedItemFluidContainer(holder, (FluidContainer)new SimpleFluidContainer(this.getCapacity(), 1, (t, f) -> f.is(ModFluidTags.ZIP_GUN_PROPELLANTS)){});
    }

    public long getCapacity() {
        return FluidConstants.fromMillibuckets((long)3000L);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add(TooltipUtils.getFluidComponent(FluidUtils.getTank(stack), FluidUtils.getTankCapacity(stack), (Fluid)ModFluids.OXYGEN.get()));
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.ZIP_GUN_INFO);
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return FluidUtils.hasFluid(stack);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        WrappedItemFluidContainer fluidContainer = this.getFluidContainer(stack);
        return (int)((double)fluidContainer.getFirstFluid().getFluidAmount() / (double)fluidContainer.getTankCapacity(0) * 13.0);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return ClientFluidHooks.getFluidColor((FluidHolder)FluidUtils.getTank(stack));
    }

    @PlatformOnly(value={"forge"})
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

